/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.MapperMetadata;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProvider<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(UpdateProvider.class);

    public String update(T entity) {
        MapperMetadata.buildColumnList(entity.getClass());
        List listFields = (List)MapperMetadata.fieldsMap.get(entity.getClass().getSimpleName());
        SQL sql = (SQL)new SQL().UPDATE(MapperMetadata.getTableName(entity.getClass()));
        int i = 0;
        while (i < listFields.size()) {
            FieldColumnMapper fieldColumnMapper = (FieldColumnMapper)listFields.get(i);
            _logger.trace("Field {} , Type {}", (Object)fieldColumnMapper.getFieldName(), (Object)fieldColumnMapper.getFieldType());
            if (!fieldColumnMapper.isIdColumn()) {
                if ((fieldColumnMapper.getFieldType().equalsIgnoreCase("String") || fieldColumnMapper.getFieldType().startsWith("byte")) && BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) == null) {
                    _logger.trace("skip  field value is null ");
                } else {
                    sql.SET(String.valueOf(fieldColumnMapper.getColumnName()) + " = #{" + fieldColumnMapper.getFieldName() + "}");
                }
            }
            ++i;
        }
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entity.getClass().getSimpleName());
        sql.WHERE(String.valueOf(idFieldColumnMapper.getColumnName()) + " = #{" + idFieldColumnMapper.getFieldName() + "}");
        _logger.trace("Update SQL : \n{}", (Object)sql);
        return sql.toString();
    }
}

