/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.client.oauth.extractors;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.maxkey.client.oauth.exceptions.OAuthException;
import org.maxkey.client.oauth.extractors.AccessTokenExtractor;
import org.maxkey.client.oauth.model.Token;
import org.maxkey.client.utils.HttpEncoder;
import org.maxkey.client.utils.Preconditions;

public class TokenExtractor20Impl
implements AccessTokenExtractor {
    private static final String TOKEN_REGEX = "access_token=([^&]+)";
    private static final String EMPTY_SECRET = "";

    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        Matcher matcher = Pattern.compile(TOKEN_REGEX).matcher(response);
        if (matcher.find()) {
            try {
                String token = HttpEncoder.decode(matcher.group(1));
                return new Token(token, EMPTY_SECRET, response);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
    }
}

