/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.security;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.security.BaseSAMLSimpleSignatureSecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SAML2HTTPPostSimpleSignRule
extends BaseSAMLSimpleSignatureSecurityPolicyRule {
    private Logger log = LoggerFactory.getLogger(SAML2HTTPPostSimpleSignRule.class);
    private ParserPool parser;
    private KeyInfoCredentialResolver keyInfoResolver;

    public SAML2HTTPPostSimpleSignRule(SignatureTrustEngine engine, ParserPool parserPool, KeyInfoCredentialResolver keyInfoCredResolver) {
        super(engine);
        this.parser = parserPool;
        this.keyInfoResolver = keyInfoCredResolver;
    }

    @Override
    protected boolean ruleHandles(HttpServletRequest request, SAMLMessageContext samlMsgCtx) {
        return "POST".equals(request.getMethod());
    }

    @Override
    protected byte[] getSignedContent(HttpServletRequest request) throws SecurityPolicyException {
        StringBuilder builder;
        block8: {
            builder = new StringBuilder();
            try {
                if (request.getParameter("SAMLRequest") != null) {
                    String samlMsg = new String(Base64.decode((String)request.getParameter("SAMLRequest")), "UTF-8");
                    builder.append("SAMLRequest=" + samlMsg);
                    break block8;
                }
                if (request.getParameter("SAMLResponse") != null) {
                    String samlMsg = new String(Base64.decode((String)request.getParameter("SAMLResponse")), "UTF-8");
                    builder.append("SAMLResponse=" + samlMsg);
                    break block8;
                }
                this.log.warn("Could not extract either a SAMLRequest or a SAMLResponse from the form control data");
                throw new SecurityPolicyException("Extract of SAMLRequest or SAMLResponse from form control data");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (request.getParameter("RelayState") != null) {
            builder.append("&RelayState=" + request.getParameter("RelayState"));
        }
        builder.append("&SigAlg=" + request.getParameter("SigAlg"));
        String constructed = builder.toString();
        if (DatatypeHelper.isEmpty((String)constructed)) {
            this.log.warn("Could not construct signed content string from form control data");
            return null;
        }
        this.log.debug("Constructed signed content string for HTTP-Post-SimpleSign {}", (Object)constructed);
        try {
            return constructed.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    protected List<Credential> getRequestCredentials(HttpServletRequest request, SAMLMessageContext samlContext) throws SecurityPolicyException {
        String kiBase64 = request.getParameter("KeyInfo");
        if (DatatypeHelper.isEmpty((String)kiBase64)) {
            this.log.debug("Form control data did not contain a KeyInfo");
            return null;
        }
        this.log.debug("Found a KeyInfo in form control data, extracting validation credentials");
        Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(KeyInfo.DEFAULT_ELEMENT_NAME);
        if (unmarshaller == null) {
            throw new SecurityPolicyException("Could not obtain a KeyInfo unmarshaller");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(Base64.decode((String)kiBase64));
        KeyInfo keyInfo = null;
        try {
            Document doc = this.parser.parse((InputStream)is);
            keyInfo = (KeyInfo)unmarshaller.unmarshall(doc.getDocumentElement());
        }
        catch (XMLParserException e) {
            this.log.warn("Error parsing KeyInfo data", (Throwable)e);
            throw new SecurityPolicyException("Error parsing KeyInfo data", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            this.log.warn("Error unmarshalling KeyInfo data", (Throwable)e);
            throw new SecurityPolicyException("Error unmarshalling KeyInfo data", (Exception)((Object)e));
        }
        if (keyInfo == null) {
            this.log.warn("Could not successfully extract KeyInfo object from the form control data");
            return null;
        }
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet((Criteria)new KeyInfoCriteria(keyInfo));
        try {
            for (Credential cred : this.keyInfoResolver.resolve((Object)criteriaSet)) {
                credentials.add(cred);
            }
        }
        catch (SecurityException e) {
            this.log.warn("Error resolving credentials from KeyInfo", (Throwable)e);
            throw new SecurityPolicyException("Error resolving credentials from KeyInfo", (Exception)((Object)e));
        }
        return credentials;
    }
}

