/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.crypto.utils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SM4Utils {
    private static final int DEFAULT_KEY_SIZE = 128;
    private static final String ALGORITHM = "SM4";
    private static final String SM4_ECB_ = "SM4/ECB/";
    private static final String SM4_CBC_ = "SM4/CBC/";
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();

    public static byte[] genKey() throws Exception {
        return SM4Utils.genKey(128);
    }

    public static byte[] genKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static String genKeyAsHex() throws Exception {
        return SM4Utils.genKeyAsHex(128);
    }

    public static String genKeyAsHex(int keySize) throws Exception {
        return Hex.toHexString((byte[])SM4Utils.genKey(keySize));
    }

    public static String genKeyAsBase64() throws Exception {
        return SM4Utils.genKeyAsBase64(128);
    }

    public static String genKeyAsBase64(int keySize) throws Exception {
        return BASE64_ENCODER.encodeToString(SM4Utils.genKey(keySize));
    }

    public static Cipher getCipher_ECB(Padding padding) throws Exception {
        return Cipher.getInstance(SM4_ECB_ + padding.name, "BC");
    }

    public static byte[] encrypt_ECB(byte[] data, byte[] key, Padding padding) throws Exception {
        Cipher cipher = SM4Utils.getCipher_ECB(padding);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM);
        cipher.init(1, secretKeySpec);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt_ECB(byte[] data, byte[] key, Padding padding) throws Exception {
        Cipher cipher = SM4Utils.getCipher_ECB(padding);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM);
        cipher.init(2, secretKeySpec);
        return cipher.doFinal(data);
    }

    public static String encryptHex_ECB(String data, String key, Padding padding) throws Exception {
        return Hex.toHexString((byte[])SM4Utils.encrypt_ECB(data.getBytes(StandardCharsets.UTF_8), Hex.decode((String)key), padding));
    }

    public static String decryptHex_ECB(String data, String key, Padding padding) throws Exception {
        return new String(SM4Utils.decrypt_ECB(Hex.decode((String)data), Hex.decode((String)key), padding), StandardCharsets.UTF_8);
    }

    public static String encryptBase64_ECB(String data, String key, Padding padding) throws Exception {
        return BASE64_ENCODER.encodeToString(SM4Utils.encrypt_ECB(data.getBytes(StandardCharsets.UTF_8), BASE64_DECODER.decode(key), padding));
    }

    public static String decryptBase64_ECB(String data, String key, Padding padding) throws Exception {
        return new String(SM4Utils.decrypt_ECB(BASE64_DECODER.decode(data), BASE64_DECODER.decode(key), padding), StandardCharsets.UTF_8);
    }

    public static Cipher getCipher_CBC(Padding padding) throws Exception {
        return Cipher.getInstance(SM4_CBC_ + padding.name, "BC");
    }

    public static byte[] encrypt_CBC(byte[] data, byte[] key, byte[] iv, Padding padding) throws Exception {
        Cipher cipher = SM4Utils.getCipher_CBC(padding);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt_CBC(byte[] data, byte[] key, byte[] iv, Padding padding) throws Exception {
        Cipher cipher = SM4Utils.getCipher_CBC(padding);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM);
        cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    public static String encryptHex_CBC(String data, String key, String iv, Padding padding) throws Exception {
        return Hex.toHexString((byte[])SM4Utils.encrypt_CBC(data.getBytes(StandardCharsets.UTF_8), Hex.decode((String)key), Hex.decode((String)iv), padding));
    }

    public static String decryptHex_CBC(String data, String key, String iv, Padding padding) throws Exception {
        return new String(SM4Utils.decrypt_CBC(Hex.decode((String)data), Hex.decode((String)key), Hex.decode((String)iv), padding), StandardCharsets.UTF_8);
    }

    public static String encryptBase64_CBC(String data, String key, String iv, Padding padding) throws Exception {
        return BASE64_ENCODER.encodeToString(SM4Utils.encrypt_CBC(data.getBytes(StandardCharsets.UTF_8), BASE64_DECODER.decode(key), BASE64_DECODER.decode(iv), padding));
    }

    public static String decryptBase64_CBC(String data, String key, String iv, Padding padding) throws Exception {
        return new String(SM4Utils.decrypt_CBC(BASE64_DECODER.decode(data), BASE64_DECODER.decode(key), BASE64_DECODER.decode(iv), padding), StandardCharsets.UTF_8);
    }

    static {
        if (Objects.isNull(Security.getProvider("BC"))) {
            Security.addProvider((Provider)PROVIDER);
        }
    }

    public static enum Padding {
        PKCS5("PKCS5Padding"),
        PKCS7("PKCS7Padding"),
        ISO10126("ISO10126Padding");

        private final String name;

        private Padding(String name) {
            this.name = name;
        }
    }
}

