/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.crypto.utils;

import java.io.UnsupportedEncodingException;

public final class HexUtils {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String hex2String(byte[] b) {
        Object result = "";
        for (int i = 0; i < b.length; ++i) {
            result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static String bytes2HexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        String s = "";
        try {
            s = new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static byte[] hex2Bytes(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; ++i) {
            int low;
            int high = Character.digit(hex[i * 2], 16);
            int value = high << 4 | (low = Character.digit(hex[i * 2 + 1], 16));
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte)value;
        }
        return raw;
    }

    public static byte[] hex2Bytes(String hex) {
        return HexUtils.hex2Bytes(hex.toCharArray());
    }
}

