/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProvider<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(QueryProvider.class);

    public String queryByCondition(Class<?> entityClass, Query query) {
        logger.trace("Query \n{}", (Object)query);
        SQL sql = (SQL)MapperMetadata.buildSelect(entityClass).WHERE(QueryBuilder.build(query));
        if (query.getGroupBy() != null) {
            sql.GROUP_BY(QueryBuilder.buildGroupBy(query));
        }
        if (query.getOrderBy() != null) {
            sql.ORDER_BY(QueryBuilder.buildOrderBy(query));
        }
        logger.trace("filter By Query SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String query(T entity) {
        SQL sql = MapperMetadata.buildSelect(entity.getClass());
        for (FieldColumnMapper fieldColumnMapper : (List)MapperMetadata.fieldsMap.get(entity.getClass().getSimpleName())) {
            Object fieldValue = BeanUtil.get(entity, fieldColumnMapper.getFieldName());
            String fieldType = fieldColumnMapper.getFieldType().toLowerCase();
            logger.trace("ColumnName {} , FieldType {} , value {}", new Object[]{fieldColumnMapper.getColumnName(), fieldType, fieldValue});
            if (fieldValue == null) {
                logger.trace("skip  {} ({}) is null ", (Object)fieldColumnMapper.getFieldName(), (Object)fieldColumnMapper.getColumnName());
                continue;
            }
            if (fieldType.equals("string") && fieldValue.equals("") || fieldType.startsWith("byte") || fieldType.equals("Int") && fieldValue.equals("0") || fieldType.equals("Long") && fieldValue.equals("0") || fieldType.equals("Integer") && fieldValue.equals("0") || fieldType.equals("Float") && fieldValue.equals("0.0") || fieldType.equals("Double") && fieldValue.equals("0.0")) continue;
            sql.WHERE(String.valueOf(fieldColumnMapper.getColumnName()) + " = #{" + fieldColumnMapper.getFieldName() + "}");
        }
        logger.trace("filter By Entity SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

