/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.entity.JpaPage;
import org.dromara.mybatis.jpa.entity.JpaPageResultsSqlCache;
import org.dromara.mybatis.jpa.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchCountProvider<T extends JpaEntity> {
    private static final Logger logger = LoggerFactory.getLogger(FetchCountProvider.class);
    public static final Cache<String, JpaPageResultsSqlCache> pageResultsBoundSqlCache = Caffeine.newBuilder().expireAfterWrite(300L, TimeUnit.SECONDS).build();

    public String executeCount(JpaPage page) {
        JpaPageResultsSqlCache pageResultsSqlCache = this.getPageResultsCache(page.getPageResultSelectUUID());
        String selectSql = StringUtils.lineBreak2Blank(pageResultsSqlCache.getSql());
        BoundSql boundSql = pageResultsSqlCache.getBoundSql();
        logger.trace("Count original SQL  :\n{}", (Object)selectSql);
        StringBuffer sql = new StringBuffer("select count(1) countrows_ ");
        StringBuffer countSql = new StringBuffer();
        if (boundSql.getParameterMappings() == null || boundSql.getParameterMappings().isEmpty()) {
            countSql.append(selectSql);
        } else {
            for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                countSql.append(selectSql.substring(0, selectSql.indexOf("?")));
                countSql.append("#{" + parameterMapping.getProperty() + "}");
                selectSql = selectSql.substring(selectSql.indexOf("?") + 1);
            }
            countSql.append(selectSql);
        }
        String countSqlLowerCase = countSql.toString().toLowerCase();
        logger.trace("Count SQL LowerCase  :\n{}", (Object)countSqlLowerCase);
        if (countSqlLowerCase.indexOf("distinct ") > 0 || countSqlLowerCase.indexOf(" group by ") > 0 || countSqlLowerCase.indexOf(" having ") > 0 || countSqlLowerCase.indexOf(" from ") != countSqlLowerCase.lastIndexOf(" from ")) {
            logger.trace("Count SQL Complex ");
            sql.append("from").append(" (").append(countSql).append(" ) count_table_");
        } else {
            int fromIndex = countSqlLowerCase.indexOf(" from ");
            int orderByIndex = countSqlLowerCase.indexOf(" order by ");
            logger.trace("Count SQL from Index {} , order by {}", (Object)fromIndex, (Object)orderByIndex);
            if (orderByIndex > -1) {
                sql.append(countSql.substring(fromIndex, orderByIndex));
            } else {
                sql.append(countSql.substring(fromIndex));
            }
        }
        logger.trace("Count SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    private JpaPageResultsSqlCache getPageResultsCache(String selectUUID) {
        JpaPageResultsSqlCache cache = (JpaPageResultsSqlCache)pageResultsBoundSqlCache.getIfPresent((Object)selectUUID);
        pageResultsBoundSqlCache.invalidate((Object)selectUUID);
        return cache;
    }
}

