/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.dromara.mybatis.jpa.util.InstanceUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyAccessorFactory;

public class BeanUtil {
    public static void copyBean(Object origin, Object target) {
        if (origin == null || target == null) {
            return;
        }
        try {
            BeanUtils.copyProperties((Object)origin, (Object)target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object cloneSupper(Object origin) {
        Object target = null;
        if (origin == null) {
            return target;
        }
        try {
            target = InstanceUtil.newInstance(origin.getClass().getSuperclass());
            BeanUtils.copyProperties((Object)target, (Object)origin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    public static Object getValue(Object bean, String field) {
        if (bean == null) {
            return null;
        }
        try {
            return PropertyAccessorFactory.forBeanPropertyAccess((Object)bean).getPropertyValue(field);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isNotNull(Map map) {
        return map != null && map.size() > 0;
    }

    public static Object get(Object bean, String fieldName) {
        try {
            return BeanUtil.invokeMethod(bean, BeanUtil.getByProperty(fieldName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object set(Object bean, String fieldName, Object value) {
        try {
            return BeanUtil.invokeMethod(bean, BeanUtil.setByProperty(fieldName), new Object[]{value});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPublicProperty(Object bean, String fieldName) {
        try {
            Field field = bean.getClass().getField(fieldName);
            return field.get(bean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean setPublicProperty(Object bean, String fieldName, Object value) {
        try {
            bean.getClass().getField(fieldName).set(bean, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Boolean isPublicProperty(Class<? extends Object> cls, String fieldName) {
        return BeanUtil.isSetProperty(cls, fieldName) != false && BeanUtil.isGetProperty(cls, fieldName) != false;
    }

    public static Boolean isPublicProperty(Object bean, String fieldName) {
        return BeanUtil.isSetProperty(bean.getClass(), fieldName) != false && BeanUtil.isGetProperty(bean.getClass(), fieldName) != false;
    }

    public static <T> Boolean isSetProperty(Class<T> cls, String fieldName) {
        Method[] method = cls.getDeclaredMethods();
        for (int i = 0; i < method.length; ++i) {
            if (method[i].getModifiers() != 1 || !method[i].getName().equals(BeanUtil.setByProperty(fieldName))) continue;
            return true;
        }
        return false;
    }

    public static <T> Boolean isGetProperty(Class<T> cls, String fieldName) {
        Method[] method = cls.getDeclaredMethods();
        for (int i = 0; i < method.length; ++i) {
            if (method[i].getModifiers() != 1 || !method[i].getName().equals(BeanUtil.getByProperty(fieldName))) continue;
            return true;
        }
        return false;
    }

    public static Object newInstance(String className) {
        return InstanceUtil.newInstance(className);
    }

    public static <T> Object newInstance(Class<T> cls) {
        return InstanceUtil.newInstance(cls);
    }

    public static Object newInstance(String className, Object[] args) {
        return InstanceUtil.newInstance(className, args);
    }

    public static <T> T newInstance(Class<T> cls, Object[] args) {
        return (T)InstanceUtil.newInstance(cls, args);
    }

    public static Object invokeMethod(Object bean, String methodName, Object[] args) throws Exception {
        return InstanceUtil.invokeMethod(bean, methodName, args);
    }

    public static Object invokeMethod(Object bean, String methodName) throws Exception {
        return InstanceUtil.invokeMethod(bean, methodName);
    }

    public static Object invokeStaticMethod(Class<?> beanClass, String methodName, Object[] args) throws Exception {
        return InstanceUtil.invokeMethod(beanClass, methodName, args);
    }

    public static Object invokeStaticMethod(Class<?> beanClass, String methodName) throws Exception {
        return InstanceUtil.invokeStaticMethod(beanClass, methodName);
    }

    public static Map<String, String> getFields(Class<? extends Object> cls) {
        Field[] flds = cls.getDeclaredFields();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < flds.length; ++i) {
            map.put(flds[i].getName(), flds[i].getType().getName());
        }
        return map;
    }

    public static Map<String, String> getFields(Object bean) {
        return BeanUtil.getFields(bean.getClass());
    }

    public static Map<String, String> getPropertyFields(Class<? extends Object> cls) {
        Field[] flds = cls.getDeclaredFields();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < flds.length; ++i) {
            String fieldName = flds[i].getName();
            if (!BeanUtil.isPublicProperty(cls, fieldName).booleanValue()) continue;
            map.put(flds[i].getName(), flds[i].getType().getName());
        }
        return map;
    }

    public static Map<String, String> getPropertyFields(Object bean) {
        return BeanUtil.getPropertyFields(bean.getClass());
    }

    public static <T> boolean isEmpty(T entity, Field field) {
        return !BeanUtil.isNotEmpty(entity, field);
    }

    public static <T> boolean isNotEmpty(T entity, Field field) {
        boolean isFieldNotEmpty = true;
        String fieldType = field.getType().getName();
        Object value = null;
        String fillValue = null;
        try {
            if (BeanUtil.get(entity, field.getName()) == null) {
                return false;
            }
            Object getValue = BeanUtil.get(entity, field.getName());
            fillValue = getValue == null ? null : getValue.toString();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        if (fieldType.equals("java.lang.String")) {
            if (String.valueOf(fillValue) == null) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("int")) {
            if (Integer.parseInt(fillValue) == 0) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("long")) {
            if (Long.parseLong(fillValue) == 0L) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("java.lang.Long")) {
            if (Long.parseLong(fillValue) == 0L) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("double")) {
            if (Double.valueOf(fillValue) == 0.0) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("float")) {
            if (Float.parseFloat(fillValue) == 0.0f) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("java.util.Date")) {
            try {
                value = BeanUtil.get(entity, field.getName());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            if (value == null) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("java.lang.Object")) {
            value = BeanUtil.get(entity, field.getName());
            if (value == null) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("char")) {
            if (fillValue != null && Character.valueOf(fillValue.charAt(0)).charValue() == '\u0000') {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("boolean")) {
            value = Boolean.parseBoolean(fillValue);
        } else if (fieldType.equals("short")) {
            if (Short.parseShort(fillValue) == 0) {
                isFieldNotEmpty = false;
            }
        } else if (fieldType.equals("byte") && Byte.parseByte(fillValue) == 0) {
            isFieldNotEmpty = false;
        }
        LogFactory.getLog(BeanUtil.class).debug((Object)("isFieldNotEmpty() fieldName : " + field.getName() + ", fieldType : " + fieldType + ", Value : " + fillValue + ", isFieldNotEmpty : " + isFieldNotEmpty));
        return isFieldNotEmpty;
    }

    public static void displayValues(Object bean) {
        Field[] flds = bean.getClass().getDeclaredFields();
        LogFactory.getLog(BeanUtil.class).debug((Object)"displayValues() *******************************************");
        LogFactory.getLog(BeanUtil.class).debug((Object)("displayValues() " + bean.getClass().getName()));
        for (int i = 0; i < flds.length; ++i) {
            String name = flds[i].getName();
            if (!BeanUtil.isGetProperty(bean.getClass(), name).booleanValue()) continue;
            LogFactory.getLog(BeanUtil.class).debug((Object)("displayValues() Field " + (i + 1) + " : " + name + " = " + String.valueOf(BeanUtil.get(bean, name))));
        }
        LogFactory.getLog(BeanUtils.class).debug((Object)"displayValues() *******************************************");
    }

    public static <T> void beanClone(T target, T origin) {
        Field[] flds = target.getClass().getDeclaredFields();
        for (int i = 0; i < flds.length; ++i) {
            String name = flds[i].getName();
            if (!BeanUtil.isPublicProperty(origin, name).booleanValue() || BeanUtil.get(origin, name) == null) continue;
            BeanUtil.set(target, name, BeanUtil.get(origin, name));
        }
    }

    public static Class[] getMethodParameterTypes(Class<?> c, String methodName) {
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            Class[] parameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName)) continue;
            return parameterTypes;
        }
        return new Class[0];
    }

    public static String getByProperty(String property) {
        String methodName = "get" + (property.length() == 1 ? "" + Character.toUpperCase(property.charAt(0)) : Character.toUpperCase(property.charAt(0)) + property.substring(1));
        LogFactory.getLog(BeanUtils.class).debug((Object)("getByProperty() methodName : " + methodName));
        return methodName;
    }

    public static String setByProperty(String property) {
        String methodName = "set" + (property.length() == 1 ? "" + Character.toUpperCase(property.charAt(0)) : Character.toUpperCase(property.charAt(0)) + property.substring(1));
        LogFactory.getLog(BeanUtils.class).debug((Object)("setByProperty() methodName : " + methodName));
        return methodName;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> mapBean = new HashMap<String, Object>();
        Field[] flds = bean.getClass().getDeclaredFields();
        LogFactory.getLog(BeanUtils.class).debug((Object)"beanToMap() *******************************************");
        LogFactory.getLog(BeanUtils.class).debug((Object)("beanToMap() " + bean.getClass().getName()));
        for (int i = 0; i < flds.length; ++i) {
            String fieldName = flds[i].getName();
            if (!BeanUtil.isGetProperty(bean.getClass(), fieldName).booleanValue()) continue;
            Object value = BeanUtil.get(bean, fieldName);
            mapBean.put(fieldName, value);
            LogFactory.getLog(BeanUtils.class).debug((Object)("beanToMap() field " + (i + 1) + " : " + fieldName + " = " + String.valueOf(value) + " type : " + String.valueOf(flds[i].getType())));
        }
        LogFactory.getLog(BeanUtils.class).debug((Object)"beanToMap() *******************************************");
        return mapBean;
    }

    public static <T> Object mapToBean(T bean, HashMap<?, ?> valueMap) {
        Map<String, String> beanFiledMap = null;
        try {
            beanFiledMap = BeanUtil.getFields(bean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (beanFiledMap == null) {
            return bean;
        }
        Iterator<Map.Entry<String, String>> fieldit = beanFiledMap.entrySet().iterator();
        LogFactory.getLog(BeanUtils.class).debug((Object)"mapToBean() *******************************************");
        LogFactory.getLog(BeanUtils.class).debug((Object)("mapToBean() " + bean.getClass().getName()));
        int i = 1;
        while (fieldit.hasNext()) {
            Map.Entry<String, String> entry = fieldit.next();
            String fieldName = entry.getKey().toString();
            Object value = null;
            String fieldType = beanFiledMap.get(fieldName);
            if (valueMap.get(fieldName) == null) continue;
            Object fillValue = valueMap.get(fieldName).toString();
            LogFactory.getLog(BeanUtils.class).debug((Object)("mapToBean() field " + i++ + " : " + fieldName + " = " + (String)fillValue + " type : " + fieldType));
            if (fieldType.equals("java.lang.String")) {
                value = String.valueOf(fillValue);
            } else if (fieldType.equals("int")) {
                value = Integer.parseInt((String)fillValue);
            } else if (fieldType.equals("java.lang.Integer")) {
                value = Integer.parseInt((String)fillValue);
            } else if (fieldType.equals("long")) {
                value = Long.parseLong((String)fillValue);
            } else if (fieldType.equals("java.lang.Long")) {
                value = Long.parseLong((String)fillValue);
            } else if (fieldType.equals("double")) {
                value = (double)Double.valueOf((String)fillValue);
            } else if (fieldType.equals("java.lang.Double")) {
                value = Double.valueOf((String)fillValue);
            } else if (fieldType.equals("float")) {
                value = Float.valueOf(Float.parseFloat((String)fillValue));
            } else if (fieldType.equals("java.lang.Float")) {
                value = Float.valueOf(Float.parseFloat((String)fillValue));
            } else if (fieldType.equals("java.util.Date")) {
                try {
                    if (((String)fillValue).length() != 10) continue;
                    fillValue = (String)fillValue + " 00:00:00";
                    value = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse((String)fillValue);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else if (fieldType.equals("java.lang.Object")) {
                value = valueMap.get(fieldName);
            } else if (fieldType.equals("char")) {
                value = Character.valueOf(((String)fillValue).charAt(0));
            } else if (fieldType.equals("boolean")) {
                value = Boolean.parseBoolean((String)fillValue);
            } else if (fieldType.equals("short")) {
                value = Short.parseShort((String)fillValue);
            } else if (fieldType.equals("byte")) {
                value = Byte.parseByte((String)fillValue);
            }
            BeanUtil.set(bean, fieldName, value);
        }
        LogFactory.getLog(BeanUtils.class).debug((Object)"mapToBean() *******************************************");
        return bean;
    }

    public static boolean isFieldBlank(Object value) {
        return value == null || StringUtils.isBlank((CharSequence)value.toString()) || "null".equalsIgnoreCase(value.toString());
    }
}

