/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.util.Objects;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.dromara.mybatis.jpa.handler.FieldAutoFillHandler;
import org.dromara.mybatis.jpa.spring.MybatisJpaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class FieldAutoFillInterceptor
implements Interceptor {
    protected static Logger logger = LoggerFactory.getLogger(FieldAutoFillInterceptor.class);
    boolean isAutoFill;
    FieldAutoFillHandler fieldAutoFillHandler;

    public Object intercept(Invocation invocation) throws Throwable {
        if (!this.isAutoFill) {
            try {
                this.isAutoFill = true;
                this.fieldAutoFillHandler = MybatisJpaContext.getBean(FieldAutoFillHandler.class);
                logger.debug("get bean by fieldAutoFillHandler class");
            }
            catch (Exception e) {
                logger.debug("get bean by fieldAutoFillHandler Exception", (Throwable)e);
            }
        }
        if (this.fieldAutoFillHandler != null) {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            Configuration configuration = mappedStatement.getConfiguration();
            Object parameter = invocation.getArgs()[1];
            MetaObject metaObject = configuration.newMetaObject(parameter);
            if (Objects.equals(SqlCommandType.INSERT, mappedStatement.getSqlCommandType())) {
                this.fieldAutoFillHandler.insertFill(metaObject);
            } else if (Objects.equals(SqlCommandType.UPDATE, mappedStatement.getSqlCommandType())) {
                this.fieldAutoFillHandler.updateFill(metaObject);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

