/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.crypto;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mybatis.jpa.crypto.SymmetricEncrypt;
import org.dromara.mybatis.jpa.crypto.impl.AesEncrypt;
import org.dromara.mybatis.jpa.crypto.impl.DesEncrypt;
import org.dromara.mybatis.jpa.crypto.impl.DesedeEncrypt;
import org.dromara.mybatis.jpa.crypto.impl.Sm4Encrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptFactory {
    private static final Logger logger = LoggerFactory.getLogger(EncryptFactory.class);
    Map<String, SymmetricEncrypt> encryptor = new HashMap<String, SymmetricEncrypt>();

    public EncryptFactory() {
        this.encryptor.put("AES".toLowerCase(), new AesEncrypt());
        this.encryptor.put("DES".toLowerCase(), new DesEncrypt());
        this.encryptor.put("DESede".toLowerCase(), new DesedeEncrypt());
        this.encryptor.put("SM4".toLowerCase(), new Sm4Encrypt());
        logger.debug("Encryptor {}", this.encryptor);
    }

    public EncryptFactory(String cryptKey) {
        if (StringUtils.isBlank((CharSequence)cryptKey)) {
            this.encryptor.put("AES".toLowerCase(), new AesEncrypt());
            this.encryptor.put("DES".toLowerCase(), new DesEncrypt());
            this.encryptor.put("DESede".toLowerCase(), new DesedeEncrypt());
            this.encryptor.put("SM4".toLowerCase(), new Sm4Encrypt());
        } else {
            this.encryptor.put("AES".toLowerCase(), new AesEncrypt(cryptKey));
            this.encryptor.put("DES".toLowerCase(), new DesEncrypt(cryptKey));
            this.encryptor.put("DESede".toLowerCase(), new DesedeEncrypt(cryptKey));
            this.encryptor.put("SM4".toLowerCase(), new Sm4Encrypt(cryptKey));
        }
        logger.debug("Encryptor {}", this.encryptor);
    }

    public SymmetricEncrypt getEncryptor(String algorithm) {
        return this.encryptor.get(algorithm.toLowerCase());
    }
}

