/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath.evaluator;

import org.apache.tsik.xpath.Context;
import org.apache.tsik.xpath.evaluator.ExprEvaluator;
import org.apache.tsik.xpath.util.Coerce;

public class UnaryMinusExprEvaluator
extends ExprEvaluator {
    ExprEvaluator operand;

    public UnaryMinusExprEvaluator(ExprEvaluator operand) {
        this.operand = operand;
    }

    public Object evaluate(Context context) {
        return new Double(-Coerce.toNumber(this.operand.evaluate(context)).doubleValue());
    }

    public int getPrecedence() {
        return 70;
    }

    public boolean isConstant() {
        return this.operand.isConstant();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.operand.getPrecedence() < this.getPrecedence()) {
            sb.append("-(");
            sb.append(this.operand.toString());
            sb.append(")");
        } else {
            sb.append("-");
            sb.append(this.operand.toString());
        }
        return sb.toString();
    }
}

