/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath;

import java.util.List;
import org.apache.tsik.resource.DOMOperations;
import org.apache.tsik.xpath.BindingContext;
import org.apache.tsik.xpath.Context;
import org.apache.tsik.xpath.Function;
import org.apache.tsik.xpath.IDDiscriminator;
import org.apache.tsik.xpath.SimpleBindingContext;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.util.NodeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathBindingContext
extends SimpleBindingContext {
    private static final DOMOperations ops = DOMOperations.getInstance();
    private IDDiscriminator idDiscriminator;
    private IDFunction idFunction;

    public XPathBindingContext(XPath xpath) {
        this(xpath, null);
    }

    public XPathBindingContext(XPath xpath, BindingContext def) {
        super(xpath.getNamespaceMap(), def);
        this.idDiscriminator = xpath.getIDDiscriminator();
    }

    public Function getFunction(String namespaceURI, String localName) {
        if (namespaceURI == null && localName.equals("id")) {
            if (this.idFunction == null) {
                this.idFunction = new IDFunction();
            }
            return this.idFunction;
        }
        return super.getFunction(namespaceURI, localName);
    }

    private class IDFunction
    implements Function {
        private IDFunction() {
        }

        public Object evaluate(Context context, List args) {
            NodeSet set = new NodeSet();
            String id = (String)args.get(0);
            if (id != null && id.length() > 0) {
                Node node = context.getNode();
                Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
                Element elem = ops.findID(doc, id, XPathBindingContext.this.idDiscriminator);
                if (elem != null) {
                    set.add(elem);
                }
            }
            return set;
        }
    }
}

