/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xpath;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tsik.xpath.BindingContext;
import org.apache.tsik.xpath.InScopeNamespacesBindingContext;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathBindingContext;
import org.apache.tsik.xpath.XPathFactory;
import org.apache.tsik.xpath.XPathFactoryImpl;
import org.apache.tsik.xpath.util.Coerce;
import org.apache.tsik.xpath.util.NodeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathAPI {
    public static final String PROP_FACTORY = "org.apache.tsik.xpath.XPathFactory";
    public static final String PROP_FACTORY_DEFAULT = "org.apache.tsik.xpath.XPathFactoryImpl";
    private static XPathFactory defaultFactory = null;
    private static BindingContext defaultBC = null;
    static /* synthetic */ Class class$org$apache$tsik$xpath$XPathFactory;

    private XPathAPI() {
        throw new Error();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XPathFactory getFactory() {
        if (defaultFactory == null) {
            Class clazz = class$org$apache$tsik$xpath$XPathFactory == null ? (class$org$apache$tsik$xpath$XPathFactory = XPathAPI.class$(PROP_FACTORY)) : class$org$apache$tsik$xpath$XPathFactory;
            synchronized (clazz) {
                if (defaultFactory == null) {
                    defaultFactory = (XPathFactory)AccessController.doPrivileged(new FactoryGetter());
                    defaultBC = defaultFactory.getDefaultBindingContext();
                }
            }
        }
        return defaultFactory;
    }

    public static Object evaluate(String expr, Node context, Element scope) {
        XPathAPI.getFactory();
        BindingContext bc = defaultBC;
        if (scope != null) {
            bc = new InScopeNamespacesBindingContext(bc, scope);
        }
        return defaultFactory.getExpression(expr).bind(bc).evaluate(context, 1, 1);
    }

    public static String evaluateToString(String expr, Node context, Element scope) {
        return Coerce.toString(XPathAPI.evaluate(expr, context, scope));
    }

    public static double evaluateToDouble(String expr, Node context, Element scope) {
        return Coerce.toNumber(XPathAPI.evaluate(expr, context, scope)).doubleValue();
    }

    public static boolean evaluateToBoolean(String expr, Node context, Element scope) {
        return Coerce.toBoolean(XPathAPI.evaluate(expr, context, scope));
    }

    public static Node evaluateToNode(String expr, Node context, Element scope) {
        NodeSet ns = (NodeSet)XPathAPI.evaluate(expr, context, scope);
        if (ns.size() == 0) {
            return null;
        }
        return (Node)ns.first();
    }

    public static Object evaluate(XPath xpath, Node context) {
        XPathAPI.getFactory();
        XPathBindingContext bc = new XPathBindingContext(xpath);
        return defaultFactory.getExpression(xpath.getXPath()).bind(bc).evaluate(context, 1, 1);
    }

    public static String evaluateToString(XPath xpath, Node context) {
        return Coerce.toString(XPathAPI.evaluate(xpath, context));
    }

    public static double evaluateToDouble(XPath xpath, Node context) {
        return Coerce.toNumber(XPathAPI.evaluate(xpath, context)).doubleValue();
    }

    public static boolean evaluateToBoolean(XPath xpath, Node context) {
        return Coerce.toBoolean(XPathAPI.evaluate(xpath, context));
    }

    public static Node evaluateToNode(XPath xpath, Node context) {
        NodeSet ns = (NodeSet)XPathAPI.evaluate(xpath, context);
        if (ns.size() == 0) {
            return null;
        }
        return (Node)ns.first();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FactoryGetter
    implements PrivilegedAction {
        private FactoryGetter() {
        }

        public Object run() {
            try {
                return (XPathFactory)Class.forName(System.getProperty(XPathAPI.PROP_FACTORY, XPathAPI.PROP_FACTORY_DEFAULT)).newInstance();
            }
            catch (Exception ex) {
                return new XPathFactoryImpl();
            }
        }
    }
}

