/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tsik.c14n.CanonicalizerFactory;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.resource.DOMOperations;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.xmlsig.elements.CanonicalizationMethod;
import org.apache.tsik.xmlsig.elements.Reference;
import org.apache.tsik.xmlsig.elements.SignatureMethod;
import org.apache.tsik.xpath.XPath;
import org.w3c.dom.Element;

public class SignedInfo
extends ElementImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$xmlsig$elements$SignedInfo == null ? (class$org$apache$tsik$xmlsig$elements$SignedInfo = SignedInfo.class$("org.apache.tsik.xmlsig.elements.SignedInfo")) : class$org$apache$tsik$xmlsig$elements$SignedInfo);
    private static String name = "SignedInfo";
    private static String prefix = Namespaces.XMLSIG.getPrefix();
    private static String uri = Namespaces.XMLSIG.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private static DOMOperations ops = DOMOperations.getInstance();
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private Vector referenceVector = new Vector();
    private String id = null;
    static /* synthetic */ Class class$org$apache$tsik$xmlsig$elements$SignedInfo;

    protected void setSignatureMethod(SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public void calculateReferences() {
        Enumeration enumer = this.referenceVector.elements();
        while (enumer.hasMoreElements()) {
            Reference ref = (Reference)enumer.nextElement();
            ref.calculate(false);
        }
    }

    public boolean verifyReferences() {
        Enumeration enumer = this.referenceVector.elements();
        while (enumer.hasMoreElements()) {
            Reference ref = (Reference)enumer.nextElement();
            if (ref.calculate(true)) continue;
            log.info("Verify reference " + ref + " failed, " + "digests do not match!");
            return false;
        }
        return true;
    }

    public byte[] canonicalize(DOMCursor cursor) {
        Map namespaces;
        DOMCursor c;
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.copyUnder(cursor);
            c = this.toXml();
            c = wc.copyUnder(c);
            c.getElement().removeAttribute("xmlns");
            namespaces = null;
        } else {
            c = this.toXml();
            namespaces = ops.getInScopeNamespaces(cursor.getElement());
            namespaces.put(null, "");
        }
        byte[] b = this.canonicalizationMethod.canonicalize(c, namespaces);
        if (log.isDebugEnabled()) {
            log.debug(new String(b));
        }
        return b;
    }

    public byte[] canonicalize() {
        DOMCursor c = this.toXml();
        byte[] b = this.canonicalizationMethod.canonicalize(c, null);
        if (log.isDebugEnabled()) {
            log.debug(new String(b));
        }
        return b;
    }

    public byte[] canonicalizeExisting(DOMCursor cursor) {
        DOMCursor c;
        if (CanonicalizerFactory.USE_OLD_IMPL) {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.copyUnder(cursor);
            c = wc;
        } else {
            c = cursor.cloneCursor();
        }
        c.moveToChild(uri, name);
        byte[] b = this.canonicalizationMethod.canonicalize(c, null);
        if (log.isDebugEnabled()) {
            log.debug(new String(b));
        }
        return b;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.id != null) {
            wc.setAttribute("Id", this.id);
        }
        this.canonicalizationMethod.toXml(wc);
        this.signatureMethod.toXml(wc);
        Enumeration enumer = this.referenceVector.elements();
        while (enumer.hasMoreElements()) {
            Reference ref = (Reference)enumer.nextElement();
            ref.toXml(wc);
        }
    }

    public DOMCursor toXml() {
        DOMWriteCursor wc = new DOMWriteCursor();
        this.toXml(wc);
        wc.moveToTop();
        return wc;
    }

    public static SignedInfo fromXml(DOMCursor cursor) {
        DOMCursor cc = SignedInfo.placeCursor(cursor, name, prefix, uri, ns);
        CanonicalizationMethod cm = CanonicalizationMethod.fromXml(cc);
        SignatureMethod sm = SignatureMethod.fromXml(cc);
        Vector<Reference> v = new Vector<Reference>();
        boolean more = cc.moveToChild(Reference.uri, Reference.name);
        while (more) {
            Reference ref = Reference.fromXml(cc);
            v.add(ref);
            more = cc.moveToSibling(Reference.uri, Reference.name);
        }
        SignedInfo signedInfo = new SignedInfo(cm, sm);
        if (v.size() > 0) {
            signedInfo.setReferences(v);
        }
        return signedInfo;
    }

    protected SignedInfo() {
        this.canonicalizationMethod = new CanonicalizationMethod();
        this.signatureMethod = new SignatureMethod();
    }

    private SignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
        this.signatureMethod = signatureMethod;
    }

    public void useExclusiveCanonicalizer(List list) {
        this.canonicalizationMethod = new CanonicalizationMethod(CanonicalizationMethod.ExclusiveCanonicalizationUri, list);
    }

    public void setReferences(Vector v) {
        this.referenceVector = v;
    }

    public Vector getReferences() {
        return this.referenceVector;
    }

    public void addReference(Reference r) {
        this.referenceVector.add(r);
    }

    public boolean isReferenced(XPath xpath) {
        Enumeration enumer = this.referenceVector.elements();
        while (enumer.hasMoreElements()) {
            Reference ref = (Reference)enumer.nextElement();
            if (!ref.isReferenced(xpath)) continue;
            return true;
        }
        return false;
    }

    public Element[] getReferencedElements() {
        ArrayList<Element> list = new ArrayList<Element>(this.referenceVector.size());
        Enumeration enumer = this.referenceVector.elements();
        while (enumer.hasMoreElements()) {
            Reference ref = (Reference)enumer.nextElement();
            Element elem = ref.getElement();
            if (elem == null) continue;
            list.add(elem);
        }
        Element[] elements = new Element[list.size()];
        list.toArray(elements);
        return elements;
    }

    public String toString() {
        String s = "[SignedInfo" + this.canonicalizationMethod + this.signatureMethod;
        Enumeration enumer = this.referenceVector.elements();
        while (enumer.hasMoreElements()) {
            Reference ref = (Reference)enumer.nextElement();
            s = s + ref;
        }
        s = s + "]";
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

