/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;

public class SignatureValue
extends ElementImpl {
    private static final String name = "SignatureValue";
    private static final String prefix = Namespaces.XMLSIG.getPrefix();
    private static final String uri = Namespaces.XMLSIG.getUri();
    private static final String[] ns = new String[]{prefix, uri};
    private String id = null;
    private byte[] value = null;

    public void setValue(byte[] value) {
        this.value = value;
    }

    void setId(String id) {
        this.id = id;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.id != null) {
            wc.setAttribute("Id", this.id);
        }
        if (this.value != null) {
            wc.setText(Base64.encode(this.value));
        }
    }

    public static SignatureValue fromXml(DOMCursor cursor) {
        DOMCursor cc = SignatureValue.placeCursor(cursor, name, prefix, uri, ns);
        SignatureValue sv = new SignatureValue();
        String s = cc.getAttribute("Id");
        if (s != null) {
            sv.setId(s);
        }
        sv.setValue(Base64.decode(cc.getText()));
        return sv;
    }

    public String toString() {
        String s = "[SignatureValue";
        if (this.id != null) {
            s = s + " Id=" + this.id;
        }
        if (this.value != null) {
            s = s + " " + Base64.encode(this.value).substring(0, 4) + "...";
        }
        return s + "]";
    }
}

