/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig.elements;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.tsik.datatypes.Base64;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;
import org.apache.tsik.util.Namespaces;

public class RSAKeyValue
extends ElementImpl {
    protected static String name = "RSAKeyValue";
    protected static String prefix = Namespaces.XMLSIG.getPrefix();
    protected static String uri = Namespaces.XMLSIG.getUri();
    protected static String[] ns = new String[]{prefix, uri};
    private static boolean DEBUG = false;
    private String modulus = null;
    private String exponent = null;

    private RSAKeyValue(String modulus, String exponent) {
        this.modulus = modulus;
        this.exponent = exponent;
    }

    public RSAKeyValue(RSAPublicKey key) {
        byte[] m = key.getModulus().toByteArray();
        m = this.fix2Complement(m);
        this.modulus = Base64.encode(m);
        byte[] e = key.getPublicExponent().toByteArray();
        e = this.fix2Complement(e);
        this.exponent = Base64.encode(e);
    }

    public static boolean isAnElementIn(DOMCursor cursor) {
        try {
            DOMCursor c = RSAKeyValue.placeCursor(cursor, name, prefix, uri, ns);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected RSAPublicKey generateRsaPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger[] m_e = new BigInteger[]{new BigInteger(1, this.fix2Complement(Base64.decode(this.modulus))), new BigInteger(1, this.fix2Complement(Base64.decode(this.exponent)))};
        KeyFactory rsaKeyFactory = KeyFactory.getInstance("rsa");
        RSAPublicKeySpec kspec = new RSAPublicKeySpec(m_e[0], m_e[1]);
        return (RSAPublicKey)rsaKeyFactory.generatePublic(kspec);
    }

    private byte[] fix2Complement(byte[] a) {
        if (a[0] == 0) {
            byte[] b = new byte[a.length - 1];
            System.arraycopy(a, 1, b, 0, a.length - 1);
            return b;
        }
        return a;
    }

    public String toString() {
        String s = "[RSAKeyValue";
        if (this.modulus != null) {
            s = s + " modulus=";
            s = s + this.modulus.substring(0, 10) + "...";
        }
        if (this.exponent != null) {
            s = s + " exponent=" + this.exponent;
        }
        return s + "]";
    }

    public void toXml(DOMWriteCursor wc) {
        DOMWriteCursor c;
        wc = wc.addUnder(uri, prefix, name);
        if (this.modulus != null) {
            c = wc.addUnder(uri, prefix, "Modulus");
            c.setText(this.modulus);
        }
        if (this.exponent != null) {
            c = wc.addUnder(uri, prefix, "Exponent");
            c.setText(this.exponent);
        }
    }

    public static RSAKeyValue fromXml(DOMCursor cursor) {
        DOMCursor cc = RSAKeyValue.placeCursor(cursor, name, prefix, uri, ns);
        String modulus = null;
        String exponent = null;
        DOMCursor c = cc.cloneCursor();
        if (c.moveToChild(uri, "Modulus")) {
            modulus = c.getText();
        }
        if ((c = cc.cloneCursor()).moveToChild(uri, "Exponent")) {
            exponent = c.getText();
        }
        return new RSAKeyValue(modulus, exponent);
    }
}

