/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xmlsig;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import org.apache.tsik.xmlsig.Asn1;
import org.apache.tsik.xmlsig.SigningKey;

public class DSASigningKey
implements SigningKey {
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private DSAPrivateKey privateKey;

    public DSASigningKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Bad key type: " + privateKey);
        }
        this.privateKey = (DSAPrivateKey)privateKey;
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public byte[] signData(byte[] data) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Signature sig = Signature.getInstance("SHA1withDSA");
            sig.initSign(this.privateKey);
            sig.update(data);
            byte[] b = sig.sign();
            int expectedLength = 46;
            if (b.length > expectedLength) {
                b = Asn1.convertToRfc2437(b);
            }
            return b;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (SignatureException se) {
            throw se;
        }
    }

    public String toString() {
        return "[DSASigningKey]";
    }
}

