/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wsx.actions;

import java.util.Map;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.wsa.WsaConstants;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.ActionViolation;
import org.apache.tsik.wsx.WsxConstants;
import org.apache.tsik.xpath.XPath;
import org.w3c.dom.Document;

public class CreateGetMetadataResponse
extends Action {
    private String actionUri;
    private String messageId;
    private String sender;
    private String recipient;
    private XPath header;
    private DOMCursor policy;

    private boolean checkPreconditions() {
        this.actionUri = this.getString("actionUri");
        this.messageId = this.getString("messageId");
        this.sender = this.getString("sender");
        this.recipient = this.getString("recipient");
        this.header = this.getXPath("header");
        Map policyMap = null;
        try {
            policyMap = (Map)this.map.get("policyMap");
            if (policyMap == null) {
                this.violations.add(new ActionViolation("policyMap missing"));
                return false;
            }
        }
        catch (Exception e) {
            this.violations.add(new ActionViolation(e));
            return false;
        }
        try {
            Document d = (Document)policyMap.get(this.recipient);
            if (d == null) {
                this.violations.add(new ActionViolation("No policy for " + this.recipient));
                return false;
            }
            this.policy = new DOMCursor(d);
        }
        catch (Exception e) {
            this.violations.add(new ActionViolation(e));
            return false;
        }
        return this.moveInputToXPath(this.header) && this.moveOutputToXPath(this.header) && this.header != null && this.actionUri != null && this.messageId != null && this.sender != null && this.recipient != null && this.policy != null;
    }

    public void execute() {
        if (!this.checkPreconditions()) {
            this.violations.add(new ActionViolation("Precondition check failed"));
            return;
        }
        this.moveOutputToXPath(this.header);
        DOMWriteCursor tmp = this.output.addUnder(WsaConstants.URI, "wsa", "Action");
        tmp.setText(WsxConstants.GET_METADATA_REQUEST_URI);
        tmp = this.output.addUnder(WsaConstants.URI, "wsa", "RelatesTo");
        tmp.setText(this.messageId);
        tmp = this.output.addUnder(WsaConstants.URI, "wsa", "To");
        tmp.setText(this.sender);
        this.moveOutputToXPath(Action.getBodyXPath());
        tmp = this.output.addUnder(WsxConstants.URI, "wsx", "Metadata");
        DOMWriteCursor tmp2 = tmp.addUnder(WsxConstants.URI, "wsx", "MetadataSection");
        tmp2.setAttribute("Dialect", WsxConstants.POLICY_URI);
        tmp2.copyUnder(this.policy);
        this.map.put("messageId", this.messageId);
        this.map.put("output", this.output.createXPath());
    }

    public boolean needsOutputDocument() {
        return true;
    }
}

