/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wsx.actions;

import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.uuid.UUID;
import org.apache.tsik.wsa.WsaConstants;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.ActionViolation;
import org.apache.tsik.wsx.WsxConstants;
import org.apache.tsik.xpath.XPath;

public class CreateGetMetadataRequest
extends Action {
    private XPath headerXpath;
    private XPath bodyXpath;
    private String sender;
    private String recipient;

    private boolean checkPreconditions() {
        this.sender = this.getString("sender");
        this.recipient = this.getString("recipient");
        this.headerXpath = this.getXPath("header");
        this.bodyXpath = this.getXPath("body");
        if (this.sender == null || this.recipient == null || this.headerXpath == null || this.bodyXpath == null) {
            return false;
        }
        return this.moveInputToXPath(this.headerXpath) && this.moveInputToXPath(this.bodyXpath);
    }

    public void execute() {
        if (!this.checkPreconditions()) {
            this.violations.add(new ActionViolation("Precondition check failed"));
            return;
        }
        this.moveOutputToXPath(this.headerXpath);
        DOMWriteCursor tmp = this.output.addUnder(WsaConstants.URI, "wsa", "Action");
        tmp.setText(WsxConstants.GET_METADATA_REQUEST_URI);
        tmp = this.output.addUnder(WsaConstants.URI, "wsa", "MessageID");
        String messageId = UUID.generate().toString();
        tmp.setText(messageId);
        tmp = this.output.addUnder(WsaConstants.URI, "wsa", "ReplyTo");
        DOMWriteCursor tmp2 = tmp.addUnder(WsaConstants.URI, "wsa", "Address");
        tmp2.setText(this.sender);
        tmp = this.output.addUnder(WsaConstants.URI, "wsa", "To");
        tmp.setText(this.recipient);
        this.moveOutputToXPath(this.bodyXpath);
        tmp = this.output.addUnder(WsxConstants.URI, "wsx", "GetMetadata");
        tmp2 = tmp.addUnder(WsxConstants.URI, "wsx", "Dialect");
        tmp2.setText(WsxConstants.POLICY_URI);
        this.map.put("messageId", messageId);
        this.map.put("output", this.output.createXPath());
    }

    public boolean needsOutputDocument() {
        return true;
    }
}

