/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.graphs;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wsp.AbstractDependencyGraph;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.actions.MapAction;
import org.apache.tsik.wss.actions.CreateBinarySecurityToken;
import org.apache.tsik.wss.actions.CreateSecurityHeader;
import org.apache.tsik.wss.actions.CreateSoapHeader;
import org.apache.tsik.wss.actions.EncryptBody;
import org.apache.tsik.wss.actions.SignBody;
import org.apache.tsik.wss.elements.Security;
import org.apache.tsik.xpath.XPath;

public class SignAndEncryptBody
extends AbstractDependencyGraph {
    public SignAndEncryptBody(PrivateKey key, X509Certificate cert, X509Certificate recipientCert) {
        HashMap map = new HashMap();
        this.actions = new Action[8];
        this.actions[0] = new CreateSoapHeader();
        this.actions[1] = new CreateSecurityHeader();
        this.actions[2] = this.mapForCreateBinarySecurityToken(cert, map);
        this.actions[3] = new CreateBinarySecurityToken();
        this.actions[4] = this.mapForSignBody(key, map);
        this.actions[5] = new SignBody();
        this.actions[6] = this.mapForEncryptBody(recipientCert, map);
        this.actions[7] = new EncryptBody();
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setMap(map);
        }
    }

    private Action mapForEncryptBody(X509Certificate recipientCert, Map map) {
        MapAction mapAction = new MapAction(map);
        String soapUri = Namespaces.SOAPENV.getUri();
        String[] ns = new String[]{"s", soapUri, "wsse", Security.uri};
        String s = "/s:Envelope/s:Header/wsse:Security";
        XPath xpath = new XPath(s, ns);
        mapAction.map("keyoutput", (Object)xpath);
        mapAction.map("cert", (Object)recipientCert);
        return mapAction;
    }

    private Action mapForSignBody(PrivateKey key, Map map) {
        MapAction mapAction = new MapAction(map);
        mapAction.map("key", (Object)key);
        String soapUri = Namespaces.SOAPENV.getUri();
        String[] ns = new String[]{"s", soapUri, "wsse", Security.uri};
        String s = "/s:Envelope/s:Header/wsse:Security";
        XPath xpath = new XPath(s, ns);
        mapAction.map("sigoutput", (Object)xpath);
        mapAction.remap("id", "tokenid");
        return mapAction;
    }

    private Action mapForCreateBinarySecurityToken(X509Certificate cert, Map map) {
        MapAction mapAction = new MapAction(map);
        mapAction.map("cert", (Object)cert);
        String soapUri = Namespaces.SOAPENV.getUri();
        String[] ns = new String[]{"s", soapUri, "wsse", Security.uri};
        String s = "/s:Envelope/s:Header/wsse:Security";
        XPath xpath = new XPath(s, ns);
        mapAction.map("output", (Object)xpath);
        return mapAction;
    }
}

