/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.graphs;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wsp.AbstractDependencyGraph;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.actions.MapAction;
import org.apache.tsik.wss.actions.CheckMustUnderstand;
import org.apache.tsik.wss.actions.CheckSecurityHeader;
import org.apache.tsik.wss.actions.DecryptBody;
import org.apache.tsik.wss.actions.VerifyBody;
import org.apache.tsik.wss.elements.EncryptedKey;
import org.apache.tsik.wss.elements.Security;
import org.apache.tsik.xpath.XPath;

public class DecryptAndVerifyBody
extends AbstractDependencyGraph {
    public DecryptAndVerifyBody(PrivateKey recipientKey, X509Certificate recipientCert, X509Certificate senderCert) {
        HashMap map = new HashMap();
        this.actions = new Action[6];
        this.actions[0] = new CheckSecurityHeader();
        this.actions[1] = new CheckMustUnderstand();
        this.actions[2] = this.mapForDecryptBody(recipientKey, recipientCert, map);
        this.actions[3] = new DecryptBody();
        this.actions[4] = this.mapForVerifyBody(senderCert, map);
        this.actions[5] = new VerifyBody();
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].setMap(map);
        }
    }

    private Action mapForDecryptBody(PrivateKey recipientKey, X509Certificate recipientCert, Map map) {
        MapAction mapAction = new MapAction(map);
        mapAction.map("key", (Object)recipientKey);
        mapAction.map("cert", (Object)recipientCert);
        String[] ns = new String[]{"s", Namespaces.SOAPENV.getUri(), "wsse", Security.uri, "xenc", EncryptedKey.uri};
        String s = "/s:Envelope/s:Header/wsse:Security/xenc:EncryptedKey";
        XPath xpath = new XPath(s, ns);
        mapAction.map("enckeyloc", (Object)xpath);
        return mapAction;
    }

    private Action mapForVerifyBody(X509Certificate senderCert, Map map) {
        MapAction mapAction = new MapAction(map);
        String soapUri = Namespaces.SOAPENV.getUri();
        String[] ns = new String[]{"s", soapUri, "wsse", Security.uri, "ds", Namespaces.XMLSIG.getUri()};
        String s = "/s:Envelope/s:Header/wsse:Security/ds:Signature";
        XPath xpath = new XPath(s, ns);
        mapAction.map("sigloc", (Object)xpath);
        mapAction.map("cert", (Object)senderCert);
        return mapAction;
    }
}

