/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.elements;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.tsik.common.SchemaMapper;
import org.apache.tsik.domutil.DOMCursor;
import org.apache.tsik.domutil.DOMWriteCursor;
import org.apache.tsik.domutil.elements.ElementImpl;

public class Timestamp
extends ElementImpl {
    private static Class c = class$org$apache$tsik$wss$elements$Timestamp == null ? (class$org$apache$tsik$wss$elements$Timestamp = Timestamp.class$("org.apache.tsik.wss.elements.Timestamp")) : class$org$apache$tsik$wss$elements$Timestamp;
    static String elementName = SchemaMapper.getName(c);
    static String prefix = SchemaMapper.getPrefix(c);
    static String uri = SchemaMapper.getUri(c);
    private static String[] ns = new String[]{prefix, uri};
    private String created;
    private String expires;
    static /* synthetic */ Class class$org$apache$tsik$wss$elements$Timestamp;

    public Timestamp(String created, String expires) {
        this.created = created;
        this.expires = expires;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, elementName);
        DOMWriteCursor c = wc.addUnder(uri, prefix, "Created");
        c.setText(this.created);
        c = wc.addUnder(uri, prefix, "Expires");
        c.setText(this.expires);
    }

    public static String generateTimestamp(int secondsAhead) {
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar ahead = Calendar.getInstance();
        ahead.add(13, secondsAhead);
        return zulu.format(ahead.getTime());
    }

    public static String generateTimestamp() {
        SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar now = Calendar.getInstance();
        return zulu.format(now.getTime());
    }

    public static Timestamp fromXml(DOMCursor cursor) {
        DOMCursor c = Timestamp.placeCursor(cursor, elementName, prefix, uri, ns);
        String created = null;
        if (c.moveToChild(uri, "Created")) {
            created = c.getText();
            c.moveToParent();
        }
        String expires = null;
        if (c.moveToChild(uri, "Expires")) {
            expires = c.getText();
            c.moveToParent();
        }
        return new Timestamp(created, expires);
    }

    public String toString() {
        String s = "[Timestamp";
        if (this.created != null) {
            s = s + " created=" + this.created;
        }
        if (this.expires != null) {
            s = s + " expires=" + this.expires;
        }
        return s + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

