/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.verifier;

import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateException;
import org.apache.tsik.verifier.SSLContextAdapterJDK14;
import org.apache.tsik.verifier.SSLTrustAdapter;
import org.apache.tsik.verifier.TrustVerificationException;
import org.apache.tsik.verifier.TrustVerifier;

public class HttpsTrustAdapter {
    public static final int VERIFIER_OR = 0;
    public static final int VERIFIER_AND = 1;
    public static final int VERIFIER_ONLY = 2;
    private TrustVerifier verifier;
    private SSLTrustAdapter sslAdapter;

    public static void verifyConnection(URLConnection connection, TrustVerifier verifier) throws TrustVerificationException, SSLPeerUnverifiedException {
        X509Certificate[] chain;
        if (!"https".equals(connection.getURL().getProtocol())) {
            verifier.verifyTrust();
            return;
        }
        try {
            chain = HttpsTrustAdapter.getServerCertificates(connection);
        }
        catch (Exception e) {
            throw new TrustVerificationException(e);
        }
        if (chain == null) {
            throw new SSLPeerUnverifiedException("No server certs available");
        }
        verifier.verifyTrust(chain);
    }

    public static X509Certificate[] getServerCertificates(URLConnection connection) throws GeneralSecurityException, SSLPeerUnverifiedException, CertificateException {
        HttpsURLConnection httpsConn;
        Certificate[] certs;
        if (SSLTrustAdapter.isJDK14Available && connection instanceof HttpsURLConnection && (certs = (httpsConn = (HttpsURLConnection)connection).getServerCertificates()) != null) {
            X509Certificate[] x509Certs = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509Certs[i] = (X509Certificate)certs[i];
            }
            return x509Certs;
        }
        return null;
    }

    public static void disableHostnameVerification(URLConnection connection) {
        if (SSLTrustAdapter.isJDK14Available && connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
            SSLContextAdapterJDK14.disableHostnameVerification(httpsConn);
            return;
        }
    }

    public HttpsTrustAdapter(TrustVerifier verifier, int verifierMode) throws GeneralSecurityException {
        this(verifier, verifierMode, (PrivateKey)null, null);
    }

    public HttpsTrustAdapter(TrustVerifier verifier, int verifierMode, PrivateKey privateKey, X509Certificate[] certChain) throws GeneralSecurityException {
        this.verifier = verifier;
        this.sslAdapter = new SSLTrustAdapter(verifier, verifierMode, privateKey, certChain);
    }

    public HttpsTrustAdapter(TrustVerifier verifier, int verifierMode, KeyStore keyStore, String password) throws GeneralSecurityException {
        this.verifier = verifier;
        this.sslAdapter = new SSLTrustAdapter(verifier, verifierMode, keyStore, password);
    }

    public void bindToConnection(URLConnection connection) throws GeneralSecurityException, TrustVerificationException {
        if (!"https".equals(connection.getURL().getProtocol())) {
            this.verifier.verifyTrust();
            return;
        }
        if (SSLTrustAdapter.isJDK14Available && connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
            httpsConn.setSSLSocketFactory(this.sslAdapter.getSocketFactory());
            return;
        }
        throw new RuntimeException("Neither JSSE nor JDK1.4 are present so SSL is not available");
    }

    public SSLTrustAdapter getSSLTrustAdapter() {
        return this.sslAdapter;
    }

    public String toString() {
        return "[HttpsTrustAdapter verifier=" + this.verifier + ", sslAdapter=" + this.sslAdapter + "]";
    }
}

