/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertInfo {
    public static final URL XKMS_PRODUCTION_URL;
    public static final URL XKMS_PILOT_URL;
    public static final X509Certificate SSL_TRIAL_ISSUER;
    private X509Certificate cert;
    private boolean httpCDP;
    private boolean ldapCDP;
    private boolean httpAIA;
    private boolean ldapAIA;
    private String fullNameCDP;
    private String aiaLocation;
    private URL xkmsUrl;
    static /* synthetic */ Class class$org$apache$tsik$util$CertInfo;

    public CertInfo(X509Certificate cert) {
        byte[] aia;
        this.cert = cert;
        byte[] cdp = cert.getExtensionValue("2.5.29.31");
        if (cdp != null) {
            String s;
            try {
                s = new String(cdp, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.toString());
            }
            int i = s.indexOf("http");
            if (i != -1) {
                this.httpCDP = true;
                this.ldapCDP = false;
            } else {
                i = s.indexOf("ldap");
                this.httpCDP = false;
                this.ldapCDP = true;
            }
            if (i != -1) {
                int j;
                this.fullNameCDP = new String(cdp, i, (int)cdp[i - 1]);
                if (!this.hasNonXkmsVeriSignIssuer() && (j = this.fullNameCDP.indexOf(".verisign.com")) >= 0) {
                    int l;
                    int k = this.fullNameCDP.indexOf("pilot");
                    this.xkmsUrl = k >= 0 && k < j ? XKMS_PILOT_URL : ((l = this.fullNameCDP.indexOf("test")) >= 0 && l < j ? XKMS_PILOT_URL : XKMS_PRODUCTION_URL);
                }
            }
        }
        if ((aia = cert.getExtensionValue("1.3.6.1.5.5.7.1.1")) != null) {
            String s;
            try {
                s = new String(aia, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e.toString());
            }
            int i = s.indexOf("http");
            if (i != -1) {
                this.httpAIA = true;
                this.ldapAIA = false;
            } else {
                i = s.indexOf("ldap");
                this.httpAIA = false;
                this.ldapAIA = true;
            }
            if (i != -1) {
                this.aiaLocation = new String(aia, i, (int)aia[i - 1]);
            }
        }
    }

    public boolean isHttpCDP() {
        return this.httpCDP;
    }

    public boolean isLdapCDP() {
        return this.ldapCDP;
    }

    public String getFullNameCDP() {
        return this.fullNameCDP;
    }

    public boolean isHttpAIA() {
        return this.httpAIA;
    }

    public boolean isLdapAIA() {
        return this.ldapAIA;
    }

    public String getAIALocation() {
        return this.aiaLocation;
    }

    public URL getXkmsUrl() {
        return this.xkmsUrl;
    }

    public boolean hasNonXkmsVeriSignIssuer() {
        return ((Object)this.cert.getIssuerDN()).equals(SSL_TRIAL_ISSUER.getSubjectDN());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            XKMS_PRODUCTION_URL = new URL("http://xkms.verisign.com/xkms/Acceptor.nano");
            XKMS_PILOT_URL = new URL("http://interop-xkms.verisign.com/xkms/Acceptor.nano");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
        InputStream is = null;
        try {
            try {
                is = (class$org$apache$tsik$util$CertInfo == null ? (class$org$apache$tsik$util$CertInfo = CertInfo.class$("org.apache.tsik.util.CertInfo")) : class$org$apache$tsik$util$CertInfo).getResourceAsStream("/ssl_trial_issuer.cer");
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                SSL_TRIAL_ISSUER = (X509Certificate)factory.generateCertificate(is);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
            Object var3_4 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        is.close();
        return;
    }
}

