/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.resource;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.tsik.resource.ReusableBuffers;

abstract class PollingInputStream
extends InputStream
implements DataOutput {
    public static final int INITIAL_CAPACITY = 2048;
    private static ReusableBuffers rbufs = new ReusableBuffers(2048);
    byte[] buffer;
    int nextbyte = 0;
    int lastbyte = 0;
    boolean streamcomplete = false;
    private byte[] numbytes = new byte[8];

    public PollingInputStream() {
        this.buffer = rbufs.getBuffer();
    }

    private void pritit(boolean read, long bytes) {
    }

    public synchronized int available() {
        if (this.lastbyte == this.nextbyte && this.streamcomplete) {
            return -1;
        }
        return this.lastbyte >= this.nextbyte ? this.lastbyte - this.nextbyte : this.buffer.length - this.nextbyte + this.lastbyte;
    }

    public void close() throws IOException {
        rbufs.releaseBuffer(this.buffer);
        super.close();
    }

    public synchronized long skip(long n) throws IOException {
        long ret = n;
        while ((long)this.available() < n && !this.streamcomplete) {
            n -= (long)this.available();
            this.nextbyte = 0;
            this.lastbyte = 0;
            if (this.fetchData() >= 0) continue;
            this.streamcomplete = true;
        }
        if (n >= 0L && !this.streamcomplete) {
            this.nextbyte = (int)(((long)this.nextbyte + n) % (long)this.buffer.length);
            this.pritit(true, n);
            return ret;
        }
        this.pritit(true, ret - n);
        if (this.streamcomplete) {
            return ret - n;
        }
        return -1L;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int read() throws IOException {
        while (this.available() <= 0) {
            if (this.streamcomplete) {
                return -1;
            }
            if (this.fetchData() >= 0) continue;
            this.streamcomplete = true;
        }
        int ret = this.buffer[this.nextbyte++] & 0xFF;
        if (this.nextbyte == this.buffer.length) {
            this.nextbyte = 0;
        }
        if (this.nextbyte == this.lastbyte) {
            this.nextbyte = 0;
            this.lastbyte = 0;
        }
        this.pritit(true, 1L);
        return ret;
    }

    public synchronized int read(byte[] retb) throws IOException {
        return this.read(retb, 0, retb.length);
    }

    public synchronized int read(byte[] retb, int offset, int len) throws IOException {
        int rem;
        while (this.available() < len && !this.streamcomplete) {
            if (this.fetchData() >= 0) continue;
            this.streamcomplete = true;
        }
        int avail = this.available();
        if (avail <= 0) {
            return -1;
        }
        int copy = len;
        if (avail < len) {
            copy = avail;
        }
        if ((rem = this.buffer.length - this.nextbyte) > copy) {
            System.arraycopy(this.buffer, this.nextbyte, retb, offset, copy);
            this.nextbyte += copy;
        } else {
            int nnxtb = copy - rem;
            System.arraycopy(this.buffer, this.nextbyte, retb, offset, rem);
            System.arraycopy(this.buffer, 0, retb, offset + rem, nnxtb);
            this.nextbyte = nnxtb;
        }
        if (this.nextbyte == this.lastbyte) {
            this.nextbyte = 0;
            this.lastbyte = 0;
        }
        this.pritit(true, copy);
        return copy;
    }

    abstract int fetchData() throws IOException;

    private synchronized boolean ensureCapacity(int bytes) {
        if (this.buffer.length - this.lastbyte > bytes) {
            return false;
        }
        if (this.buffer.length - this.available() > bytes) {
            return false;
        }
        byte[] newbuffer = new byte[this.buffer.length * 2];
        if (this.lastbyte >= this.nextbyte) {
            int nstb = this.lastbyte - this.nextbyte;
            System.arraycopy(this.buffer, this.nextbyte, newbuffer, 0, nstb);
            this.lastbyte = nstb;
            this.nextbyte = 0;
            this.buffer = newbuffer;
            this.pritit(false, 0L);
            return true;
        }
        int rem = this.buffer.length - this.nextbyte;
        System.arraycopy(this.buffer, this.nextbyte, newbuffer, 0, rem);
        System.arraycopy(this.buffer, 0, newbuffer, rem, this.lastbyte);
        this.lastbyte += rem;
        this.nextbyte = 0;
        this.buffer = newbuffer;
        this.pritit(false, 0L);
        return true;
    }

    private synchronized void addBytes(byte[] b, int off, int len) {
        this.ensureCapacity(len);
        if (this.lastbyte >= this.nextbyte) {
            if (this.buffer.length - this.lastbyte > len) {
                System.arraycopy(b, off, this.buffer, this.lastbyte, len);
                this.lastbyte += len;
            } else {
                int rem = this.buffer.length - this.lastbyte;
                System.arraycopy(b, off, this.buffer, this.lastbyte, rem);
                this.lastbyte = len - rem;
                System.arraycopy(b, off + rem, this.buffer, 0, this.lastbyte);
            }
        } else {
            System.arraycopy(b, off, this.buffer, this.lastbyte, len);
            this.lastbyte += len;
        }
        if (this.lastbyte == this.buffer.length) {
            this.lastbyte = 0;
        }
        this.pritit(false, len);
    }

    public synchronized void write(int b) throws IOException {
        this.ensureCapacity(1);
        this.buffer[this.lastbyte++] = (byte)(b & 0xFF);
        if (this.lastbyte == this.buffer.length) {
            this.lastbyte = 0;
        }
        this.pritit(false, 1L);
    }

    public synchronized void write(byte[] b) throws IOException {
        this.addBytes(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.addBytes(b, off, len);
    }

    public synchronized void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public synchronized void writeByte(int v) throws IOException {
        this.write(v);
    }

    public synchronized void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public synchronized void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    public synchronized void writeInt(int v) throws IOException {
        this.numbytes[0] = (byte)(v >>> 24 & 0xFF);
        this.numbytes[1] = (byte)(v >>> 16 & 0xFF);
        this.numbytes[2] = (byte)(v >>> 8 & 0xFF);
        this.numbytes[3] = (byte)(v >>> 0 & 0xFF);
        this.write(this.numbytes, 0, 4);
    }

    public synchronized void writeLong(long v) throws IOException {
        this.numbytes[0] = (byte)(v >>> 56 & 0xFFL);
        this.numbytes[1] = (byte)(v >>> 48 & 0xFFL);
        this.numbytes[2] = (byte)(v >>> 40 & 0xFFL);
        this.numbytes[3] = (byte)(v >>> 32 & 0xFFL);
        this.numbytes[4] = (byte)(v >>> 24 & 0xFFL);
        this.numbytes[5] = (byte)(v >>> 16 & 0xFFL);
        this.numbytes[6] = (byte)(v >>> 8 & 0xFFL);
        this.numbytes[7] = (byte)(v >>> 0 & 0xFFL);
        this.write(this.numbytes, 0, 8);
    }

    public synchronized void writeFloat(float v) throws IOException {
        int fv = Float.floatToIntBits(v);
        this.writeInt(fv);
    }

    public synchronized void writeDouble(double v) throws IOException {
        long dv = Double.doubleToLongBits(v);
        this.writeLong(dv);
    }

    public synchronized void writeBytes(String s) throws IOException {
        byte[] b = s.getBytes();
        this.write(b);
    }

    public synchronized void writeChars(String s) throws IOException {
        int len = s.length();
        this.ensureCapacity(len + 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.writeChar(v);
        }
    }

    public synchronized void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        this.ensureCapacity(strlen + 2);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(utflen);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
    }
}

