/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.resource;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.tsik.resource.DOMSerializationV1;
import org.apache.tsik.resource.DOMSerializationV2;
import org.apache.tsik.resource.DOMSerializationV3;
import org.apache.tsik.resource.ResourceFactory;
import org.apache.tsik.resource.XMLResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DOMSerialization {
    private IOException otherThreadException = null;
    private static final boolean USE_PIPES = false;

    public void serialize(Node dom, OutputStream out) throws IOException {
        new DOMSerializationV3().serialize(dom, out);
    }

    public void serialize(Node dom, DataOutput out) throws IOException {
        new DOMSerializationV3().serialize(dom, out);
    }

    public Node deSerialize(InputStream in) throws IOException {
        return this.deSerialize(new DataInputStream(in));
    }

    public Node deSerialize(DataInput input) throws IOException {
        int version = input.readInt();
        switch (version) {
            case 1: {
                return this.fixNode(new DOMSerializationV1().deSerialize(input));
            }
            case 2: {
                return this.fixNode(new DOMSerializationV2().deSerialize(input));
            }
            case 3: {
                return new DOMSerializationV3().deSerialize(input);
            }
        }
        throw new IOException("Unrecognized DOMSerialization version number " + version);
    }

    public InputStream getSerializationStream(Node node) throws IOException {
        return new DOMSerializationV3().getSerializationStream(node);
    }

    private Node fixNode(Node node) throws IOException {
        XMLResource xmlres = ResourceFactory.getXMLResource();
        CharArrayWriter caw = new CharArrayWriter();
        xmlres.publish(node, (Writer)caw);
        CharArrayReader car = new CharArrayReader(caw.toCharArray());
        Document fixed = xmlres.parseXML(car);
        switch (node.getNodeType()) {
            case 9: {
                return fixed;
            }
            case 1: {
                return fixed.getDocumentElement();
            }
        }
        throw new IOException("fixNode: don't know how to fix node type " + node.getNodeType());
    }
}

