/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.domutil;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tsik.datatypes.QName;
import org.apache.tsik.resource.DOMOperations;
import org.apache.tsik.resource.ResourceFactory;
import org.apache.tsik.resource.XMLResource;
import org.apache.tsik.xpath.XPath;
import org.apache.tsik.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMCursor {
    static final DOMOperations staticOps = new DOMOperations();
    static final XMLResource xml = ResourceFactory.getXMLResource();
    private static final DOMCursor[] NO_DOM_CURSORS = new DOMCursor[0];
    private static final boolean INSTANCE_DOM_OPS = false;
    DOMOperations ops;
    Document document;
    Element element;

    public DOMCursor(Document document) {
        this.initDocument(document);
    }

    private void initDocument(Document document) {
        this.ops = staticOps;
        this.element = document.getDocumentElement();
        this.document = document;
    }

    public DOMCursor(Element element) {
        this.initElement(element);
    }

    private void initElement(Element element) {
        boolean hasParent;
        this.ops = staticOps;
        this.document = element.getOwnerDocument();
        if (this.document == null) {
            hasParent = false;
        } else {
            Node parent;
            for (parent = element.getParentNode(); parent != null && parent != this.document; parent = parent.getParentNode()) {
            }
            boolean bl = hasParent = parent == this.document;
        }
        if (hasParent) {
            this.element = element;
        } else {
            this.document = xml.createDocument();
            this.element = (Element)this.document.importNode(element, true);
            this.document.appendChild(this.element);
        }
    }

    public DOMCursor(Node node) throws IllegalArgumentException {
        short type = node.getNodeType();
        if (type == 9) {
            this.initDocument((Document)node);
        } else if (type == 1) {
            this.initElement((Element)node);
        } else {
            throw new IllegalArgumentException("not a document or element");
        }
    }

    DOMCursor(DOMCursor other, Element element) {
        this.ops = other.ops;
        this.document = other.document;
        this.element = element;
    }

    public final DOMCursor cloneCursor() {
        return new DOMCursor(this, this.element);
    }

    public final boolean isDocumentEmpty() {
        return this.element == null;
    }

    public final boolean moveToChild(int index) {
        if (this.element == null) {
            return false;
        }
        Element e = null;
        if (index > 0) {
            e = this.ops.firstElementChild(this.element);
            while (e != null && index > 1) {
                e = this.ops.nextElementSibling(e);
                --index;
            }
        } else if (index < 0) {
            e = this.ops.lastElementChild(this.element);
            while (e != null && index < -1) {
                e = this.ops.previousElementSibling(e);
                ++index;
            }
        } else {
            return true;
        }
        if (e != null) {
            this.element = e;
            return true;
        }
        return false;
    }

    public final boolean moveToChild(String namespaceURI, String localName) {
        if (this.element == null) {
            return false;
        }
        Element e = this.ops.firstElementChild(this.element);
        while (e != null) {
            if (this.ops.matchName(e, namespaceURI, localName)) {
                this.element = e;
                return true;
            }
            e = this.ops.nextElementSibling(e);
        }
        return false;
    }

    public final boolean moveToSibling(int index) {
        if (this.element == null) {
            return false;
        }
        Element e = this.element;
        if (index > 0) {
            while (e != null && index > 0) {
                e = this.ops.nextElementSibling(e);
                --index;
            }
        } else if (index < 0) {
            while (e != null && index < 0) {
                e = this.ops.previousElementSibling(e);
                ++index;
            }
        } else {
            return true;
        }
        if (e != null) {
            this.element = e;
            return true;
        }
        return false;
    }

    public final boolean moveToSibling(String namespaceURI, String localName) {
        Element e = this.element;
        while (e != null) {
            if ((e = this.ops.nextElementSibling(e)) == null || !this.ops.matchName(e, namespaceURI, localName)) continue;
            this.element = e;
            return true;
        }
        return false;
    }

    public final boolean moveToDescendant(String namespaceURI, String localName, boolean includeSelf) {
        if (this.element == null) {
            return false;
        }
        if (includeSelf && this.ops.matchName(this.element, namespaceURI, localName)) {
            return true;
        }
        return this.moveToDescendant(this.element, namespaceURI, localName);
    }

    private boolean moveToDescendant(Element parent, String namespaceURI, String localName) {
        Element e = this.ops.firstElementChild(parent);
        while (e != null) {
            if (this.ops.matchName(e, namespaceURI, localName)) {
                this.element = e;
                return true;
            }
            if (this.moveToDescendant(e, namespaceURI, localName)) {
                return true;
            }
            e = this.ops.nextElementSibling(e);
        }
        return false;
    }

    public final boolean moveToParent() {
        Node n;
        if (this.element != null && (n = this.element.getParentNode()).getNodeType() == 1) {
            this.element = (Element)n;
            return true;
        }
        return false;
    }

    public final boolean moveToTop() {
        this.element = this.document.getDocumentElement();
        return this.element != null;
    }

    public final boolean atTop() {
        return this.element != null && this.element == this.document.getDocumentElement();
    }

    public final boolean moveToXPath(XPath xpath) throws IllegalArgumentException {
        if (this.element == null) {
            return false;
        }
        String expr = xpath.getXPath();
        if ("/".equals(expr) || "/*".equals(expr)) {
            return this.moveToTop();
        }
        if ("/*/*[last()]".equals(expr)) {
            if (this.moveToTop() && this.moveToChild(-1)) {
                return true;
            }
        } else {
            String id = xpath.toID();
            if (id != null) {
                Element e = this.ops.findID(this.document, id, xpath.getIDDiscriminator());
                if (e != null) {
                    this.element = e;
                    return true;
                }
            } else {
                try {
                    Node n = XPathAPI.evaluateToNode(xpath, this.element);
                    if (n != null && n.getNodeType() == 1) {
                        this.element = (Element)n;
                        return true;
                    }
                }
                catch (ClassCastException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public final String evalToString(XPath xpath) {
        return XPathAPI.evaluateToString(xpath, this.element);
    }

    public final String evalToString(XPath xpath, boolean docRelative) {
        return XPathAPI.evaluateToString(xpath, docRelative ? this.document : this.element);
    }

    public final boolean evalToBoolean(XPath xpath) {
        return XPathAPI.evaluateToBoolean(xpath, this.element);
    }

    public final boolean evalToBoolean(XPath xpath, boolean docRelative) {
        return XPathAPI.evaluateToBoolean(xpath, docRelative ? this.document : this.element);
    }

    public final double evalToDouble(XPath xpath) {
        return XPathAPI.evaluateToDouble(xpath, this.element);
    }

    public final double evalToDouble(XPath xpath, boolean docRelative) {
        return XPathAPI.evaluateToDouble(xpath, docRelative ? this.document : this.element);
    }

    public final DOMCursor[] evalToElements(XPath xpath) {
        return this.evalToElements(xpath, false);
    }

    public final DOMCursor[] evalToElements(XPath xpath, boolean docRelative) {
        Object o = XPathAPI.evaluate(xpath, docRelative ? this.document : this.element);
        if (o == null) {
            return NO_DOM_CURSORS;
        }
        if (!(o instanceof Set)) {
            throw new IllegalArgumentException("XPath does not evaluate to a NodeSet: " + xpath.getXPath() + " got class: " + o.getClass());
        }
        Set set = (Set)o;
        DOMCursor[] cursors = new DOMCursor[set.size()];
        Iterator nodes = set.iterator();
        for (int i = 0; i < cursors.length; ++i) {
            Node node = (Node)nodes.next();
            if (node.getNodeType() != 1) {
                throw new IllegalArgumentException("XPath evaluates to a non-element node: " + xpath.getXPath() + " got node type: " + node.getNodeType());
            }
            cursors[i] = new DOMCursor((Element)node);
        }
        return cursors;
    }

    public final String getAttribute(String localName) throws IllegalStateException {
        Attr a;
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return (a = this.ops.getAttributeNodeNS(this.element, null, localName)) != null ? a.getValue() : null;
    }

    public final String getAttribute(String namespaceURI, String localName) throws IllegalStateException {
        Attr a;
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return (a = this.ops.getAttributeNodeNS(this.element, namespaceURI, localName)) != null ? a.getValue() : null;
    }

    public final XPath getXPathAttribute(String localName) throws IllegalStateException {
        return this.getXPathAttribute(null, localName);
    }

    public final XPath getXPathAttribute(String namespaceURI, String localName) throws IllegalStateException {
        String val = this.getAttribute(namespaceURI, localName);
        if (val == null) {
            return null;
        }
        return this.getXPathInContext(val);
    }

    public final XPath createXPath() throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return this.createXPath((Node)null);
    }

    public final XPath createXPath(DOMCursor relativeTo) throws IllegalArgumentException, IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if (this.document != relativeTo.document) {
            throw new IllegalArgumentException("relativeTo must be for the same document");
        }
        return this.createXPath(relativeTo.element);
    }

    public final boolean matchName(String namespaceURI, String localName) {
        return this.atElement(namespaceURI, localName);
    }

    public final String getNamespaceURI() throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return this.ops.getNamespaceURI(this.element);
    }

    public final String getLocalName() throws IllegalStateException {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return this.ops.getLocalName(this.element);
    }

    public final String getText() throws IllegalStateException {
        String t;
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return (t = this.ops.stringValueOfNode(this.element)) == null ? "" : t;
    }

    public final XPath getXPathText() throws IllegalStateException {
        return this.getXPathInContext(this.getText());
    }

    public XPath getXPathInContext(String val) {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        Map ns = this.ops.getInScopeNamespaces(this.element);
        if ((val = val.trim()).length() > 1 && val.charAt(0) == '#') {
            return XPath.fromXPointer(val, ns);
        }
        return new XPath(val, ns);
    }

    public QName getQNameInContext(String val) {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return new QName(val.trim(), this.ops.getInScopeNamespaces(this.element));
    }

    public Map getNamespaces() {
        if (this.element == null) {
            this.throwDocEmpty();
        }
        return this.ops.getInScopeNamespaces(this.element);
    }

    public final Document getDocument() {
        return this.document;
    }

    public final Element getElement() {
        return this.element;
    }

    final void throwDocEmpty() throws IllegalStateException {
        throw new IllegalStateException("document is empty");
    }

    private XPath createXPath(Node rel) {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        StringBuffer buf = new StringBuffer();
        if (rel != null) {
            if (rel == this.element) {
                buf.append('.');
            } else {
                while (rel != this.element && !this.isAncestor(rel, this.element)) {
                    buf.append("../");
                    rel = rel.getParentNode();
                }
            }
        } else {
            buf.append('/');
            rel = this.document;
        }
        while (rel != this.element) {
            Node childNode = this.element;
            while (childNode.getParentNode() != rel) {
                childNode = childNode.getParentNode();
            }
            Element child = childNode;
            String localName = this.ops.getLocalName(child);
            String nsPrefix = null;
            String nsURI = this.ops.getNamespaceURI(child);
            if (nsURI != null) {
                Object uri;
                nsPrefix = this.ops.getPrefix(child);
                if (nsPrefix != null && (uri = nsMap.get(nsPrefix)) != null && !uri.equals(nsURI)) {
                    nsPrefix = null;
                }
                if (nsPrefix == null) {
                    Iterator i = nsMap.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        if (!nsURI.equals(e.getValue())) continue;
                        nsPrefix = (String)e.getKey();
                        break;
                    }
                }
                if (nsPrefix == null) {
                    int i = 0;
                    while (nsMap.get(nsPrefix = "ns" + i) != null) {
                        ++i;
                    }
                }
                buf.append(nsPrefix);
                buf.append(':');
                nsMap.put(nsPrefix, nsURI);
            }
            buf.append(localName);
            int index = 1;
            Element sib = child;
            while (sib != null) {
                if ((sib = this.ops.previousElementSibling(sib)) == null || !this.ops.matchName(sib, nsURI, localName)) continue;
                ++index;
            }
            if (index > 1) {
                buf.append('[');
                buf.append(index);
                buf.append(']');
            } else {
                buf.append("[1]");
            }
            buf.append('/');
            rel = childNode;
        }
        int lenMinusOne = buf.length() - 1;
        if (lenMinusOne >= 0 && buf.charAt(lenMinusOne) == '/') {
            buf.setLength(lenMinusOne);
        }
        return new XPath(buf.toString(), nsMap);
    }

    private boolean isAncestor(Node parent, Node child) {
        while (child != null) {
            if ((child = child.getParentNode()) != parent) continue;
            return true;
        }
        return false;
    }

    public boolean atElement(String namespaceURI, String localName) {
        if (this.element == null) {
            return false;
        }
        return this.ops.matchName(this.element, namespaceURI, localName);
    }

    public boolean contains(DOMCursor other) {
        if (this.document != other.document) {
            return false;
        }
        if (this.element == null || other.element == null) {
            return false;
        }
        if (this.element == other.element) {
            return true;
        }
        return this.isAncestor(this.element, other.element);
    }

    public boolean equals(Object o) {
        try {
            DOMCursor other = (DOMCursor)o;
            return this.document == other.document && this.element == other.element;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String publish(boolean prettyPrint) throws IllegalStateException, IOException {
        Node node;
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if ((node = this.element) == this.document.getDocumentElement()) {
            node = this.document;
        }
        StringWriter out = new StringWriter();
        xml.publish(node, (Writer)out, prettyPrint ? 1 : 0);
        return out.toString();
    }

    public void publish(OutputStream out, boolean prettyPrint) throws IllegalStateException, IOException {
        Node node;
        if (this.element == null) {
            this.throwDocEmpty();
        }
        if ((node = this.element) == this.document.getDocumentElement()) {
            node = this.document;
        }
        xml.publish(node, out, prettyPrint ? 1 : 0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[DOMCursor ");
        if (this.element == null) {
            buf.append('/');
        } else {
            buf.append(this.createXPath().getXPath());
        }
        buf.append(']');
        return buf.toString();
    }
}

