/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.DefaultJWSHeaderFilter;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeaderFilter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.crypto.MACProvider;
import com.nimbusds.jose.util.Base64URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACVerifier
extends MACProvider
implements JWSVerifier {
    private final DefaultJWSHeaderFilter headerFilter = new DefaultJWSHeaderFilter(this.supportedAlgorithms());

    public MACVerifier(byte[] sharedSecret) {
        super(sharedSecret);
    }

    public JWSHeaderFilter getJWSHeaderFilter() {
        return this.headerFilter;
    }

    public boolean verify(ReadOnlyJWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        String jcaAlg = MACVerifier.getJCAAlgorithmName(header.getAlgorithm());
        byte[] hmac = HMAC.compute(jcaAlg, this.getSharedSecret(), signedContent);
        Base64URL expectedSignature = Base64URL.encode(hmac);
        return expectedSignature.equals(signature);
    }
}

