/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEAlgorithmProvider;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseJWEProvider
implements JWEAlgorithmProvider {
    private final Set<JWEAlgorithm> algs;
    private final Set<EncryptionMethod> encs;

    public BaseJWEProvider(Set<JWEAlgorithm> algs, Set<EncryptionMethod> encs) {
        if (algs == null) {
            throw new IllegalArgumentException("The supported JWE algorithm set must not be null");
        }
        this.algs = Collections.unmodifiableSet(algs);
        if (encs == null) {
            throw new IllegalArgumentException("The supported encryption methods must not be null");
        }
        this.encs = encs;
    }

    @Override
    public Set<JWEAlgorithm> supportedAlgorithms() {
        return this.algs;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return this.encs;
    }
}

