/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseDomain;
import org.apache.mybatis.jpa.persistence.MapperMetadata;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlProviderUpdate<T extends JpaBaseDomain> {
    private static final Logger _logger = LoggerFactory.getLogger(SqlProviderUpdate.class);

    public String update(T entity) {
        MapperMetadata.buildColumnList(entity.getClass());
        List listFields = (List)MapperMetadata.fieldsMap.get(entity.getClass().getSimpleName());
        SQL sql = new SQL();
        sql.UPDATE(MapperMetadata.getTableName(entity.getClass()));
        for (int i = 0; i < listFields.size(); ++i) {
            FieldColumnMapper fieldColumnMapper = (FieldColumnMapper)listFields.get(i);
            if (fieldColumnMapper.isIdColumn() || fieldColumnMapper.getFieldType().equalsIgnoreCase("String") && BeanUtil.getValue(entity, fieldColumnMapper.getFieldName()) == null) continue;
            sql.SET(fieldColumnMapper.getColumnName() + "=#{" + fieldColumnMapper.getFieldName() + "}");
        }
        FieldColumnMapper idFieldColumnMapper = MapperMetadata.getIdColumn(entity.getClass().getSimpleName());
        sql.WHERE(idFieldColumnMapper.getColumnName() + "=#{" + idFieldColumnMapper.getFieldName() + "}");
        _logger.trace("Update SQL : \n" + sql);
        return sql.toString();
    }
}

