/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.util;

import jakarta.persistence.Column;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mybatis.jpa.functions.IGetter;
import org.dromara.mybatis.jpa.util.StrUtils;

public class LambdaUtil {
    public static final String PREFIX_GET = "get";
    public static final String PREFIX_IS = "is";
    public static final String WRITE_REPLACE = "writeReplace";

    public static <T> String getColumnName(IGetter<T> func) {
        SerializedLambda lambda = LambdaUtil.getSerializedLambda(func);
        String methodName = lambda.getImplMethodName();
        if (methodName.startsWith(PREFIX_GET)) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith(PREFIX_IS)) {
            methodName = methodName.substring(2);
        }
        String fieldName = StrUtils.firstToLowerCase(methodName);
        String implClass = lambda.getImplClass();
        Class<?> clazz = LambdaUtil.forName(implClass);
        Field field = LambdaUtil.findField(clazz, fieldName);
        return LambdaUtil.getColumnName(field, fieldName);
    }

    private static String getColumnName(Field field, String fieldName) {
        return Optional.ofNullable(field).map(f -> f.getAnnotation(Column.class)).map(Column::name).filter(name -> !"".equals(name)).orElseGet(() -> fieldName);
    }

    public static SerializedLambda getSerializedLambda(Serializable func) {
        Class<?> clazz = func.getClass();
        try {
            Method method = clazz.getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            method.setAccessible(Boolean.TRUE);
            return (SerializedLambda)method.invoke((Object)func, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("can't parser getter name of " + clazz.getClass().getSimpleName(), e);
        }
    }

    public static Class<?> forName(String impClass) {
        try {
            return Class.forName(impClass.replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ClassNotFoundException class name of " + impClass, e);
        }
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            Class<?> searchType = clazz;
            while (Object.class != searchType && searchType != null) {
                Field[] fields;
                Field[] fieldArray = fields = searchType.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (fieldName.equals(field.getName())) {
                        return field;
                    }
                    ++n2;
                }
                searchType = searchType.getSuperclass();
            }
        }
        return null;
    }
}

