/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dromara.mybatis.jpa.query.Condition;
import org.dromara.mybatis.jpa.query.ConditionValue;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaQueryBuilder {
    private static final Logger _logger = LoggerFactory.getLogger(LambdaQueryBuilder.class);

    public static String build(LambdaQuery lambdaQuery) {
        StringBuffer conditionString = new StringBuffer("");
        List<Condition> conditions = lambdaQuery.getConditions();
        for (Condition condition : conditions) {
            condition.setColumn(condition.getColumn().replace("'", "").replace(" ", "").replace(";", ""));
            if (condition.getExpression().equals((Object)Operator.and) || condition.getExpression().equals((Object)Operator.or)) {
                conditionString.append(" ").append(condition.getExpression().getOperator()).append(" ");
                Object object = condition.getValue();
                if (!(object instanceof LambdaQuery)) continue;
                LambdaQuery lambdaQueryValue = (LambdaQuery)object;
                conditionString.append(" ( ").append(LambdaQueryBuilder.build(lambdaQueryValue)).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.like) || condition.getExpression().equals((Object)Operator.notLike)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeLeft)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'%").append(condition.getValue().toString()).append("'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.likeRight)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append("'").append(condition.getValue().toString()).append("%'");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.eq) || condition.getExpression().equals((Object)Operator.notEq) || condition.getExpression().equals((Object)Operator.gt) || condition.getExpression().equals((Object)Operator.ge) || condition.getExpression().equals((Object)Operator.lt) || condition.getExpression().equals((Object)Operator.le)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(ConditionValue.valueOf(condition.getValue()));
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.between) || condition.getExpression().equals((Object)Operator.notBetween)) {
                conditionString.append(" ( ").append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator()).append(" ");
                conditionString.append(ConditionValue.valueOf(condition.getValue()));
                conditionString.append(" and ");
                conditionString.append(ConditionValue.valueOf(condition.getValue2())).append(" ) ");
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.isNull) || condition.getExpression().equals((Object)Operator.isNotNull)) {
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                continue;
            }
            if (condition.getExpression().equals((Object)Operator.in) || condition.getExpression().equals((Object)Operator.notIn)) {
                Object object;
                Object objects;
                StringBuffer conditionArray;
                _logger.trace("value class CanonicalName {}", (Object)condition.getValue().getClass().getCanonicalName());
                if (condition.getValue().getClass().isArray()) {
                    conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                    conditionString.append(" ( ");
                    conditionArray = new StringBuffer();
                    objects = (Object[])condition.getValue();
                    Object[] objectArray = objects;
                    int n = ((Object[])objects).length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = objectArray[n2];
                        if (conditionArray.length() > 0) {
                            conditionArray.append(" , ");
                        }
                        conditionArray.append(ConditionValue.valueOf(object));
                        ++n2;
                    }
                    conditionString.append(conditionArray);
                    conditionString.append(" ) ");
                    continue;
                }
                if (condition.getValue().getClass().getCanonicalName().equalsIgnoreCase("java.util.ArrayList")) {
                    conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                    conditionString.append(" ( ");
                    conditionArray = new StringBuffer();
                    objects = (ArrayList)condition.getValue();
                    Iterator iterator = ((ArrayList)objects).iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (conditionArray.length() > 0) {
                            conditionArray.append(" , ");
                        }
                        conditionArray.append(ConditionValue.valueOf(object));
                    }
                    conditionString.append(conditionArray);
                    conditionString.append(" ) ");
                    continue;
                }
                if (!condition.getValue().getClass().getCanonicalName().equalsIgnoreCase("java.util.LinkedList")) continue;
                conditionString.append(condition.getColumn()).append(" ").append(condition.getExpression().getOperator());
                conditionString.append(" ( ");
                conditionArray = new StringBuffer();
                objects = (LinkedList)condition.getValue();
                Iterator iterator = ((AbstractSequentialList)objects).iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (conditionArray.length() > 0) {
                        conditionArray.append(" , ");
                    }
                    conditionArray.append(ConditionValue.valueOf(object));
                }
                conditionString.append(conditionArray);
                conditionString.append(" ) ");
                continue;
            }
            if (!condition.getExpression().equals((Object)Operator.condition)) continue;
            conditionString.append(condition.getColumn().replace(";", ""));
        }
        return conditionString.toString();
    }

    public static String buildGroupBy(LambdaQuery lambdaQuery) {
        StringBuffer groupBy = new StringBuffer();
        List<Condition> conditions = lambdaQuery.getGroupBy();
        for (Condition condition : conditions) {
            if (groupBy.length() > 0) {
                groupBy.append(" , ");
            }
            groupBy.append(condition.getColumn());
        }
        return groupBy.toString();
    }

    public static String buildOrderBy(LambdaQuery lambdaQuery) {
        StringBuffer orderBy = new StringBuffer();
        List<Condition> conditions = lambdaQuery.getGroupBy();
        for (Condition condition : conditions) {
            if (orderBy.length() > 0) {
                orderBy.append(" , ");
            }
            orderBy.append(condition.getColumn()).append(" ").append(condition.getValue());
        }
        return orderBy.toString();
    }
}

