/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Temporal;
import jakarta.persistence.Transient;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dromara.mybatis.jpa.annotations.ColumnDefault;
import org.dromara.mybatis.jpa.annotations.Encrypted;
import org.dromara.mybatis.jpa.annotations.PartitionKey;
import org.dromara.mybatis.jpa.annotations.SoftDelete;
import org.dromara.mybatis.jpa.metadata.FieldColumnMapper;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldMetadata {
    private static final Logger logger = LoggerFactory.getLogger(FieldMetadata.class);
    static ConcurrentMap<String, List<FieldColumnMapper>> fieldsMap = new ConcurrentHashMap<String, List<FieldColumnMapper>>();

    public static FieldColumnMapper getIdColumn(Class<?> entityClass) {
        List listFields = (List)fieldsMap.get(entityClass.getName());
        FieldColumnMapper idFieldColumnMapper = null;
        int i = 0;
        while (i < listFields.size()) {
            if (((FieldColumnMapper)listFields.get(i)).isIdColumn()) {
                idFieldColumnMapper = (FieldColumnMapper)listFields.get(i);
                break;
            }
            ++i;
        }
        return idFieldColumnMapper;
    }

    public static FieldColumnMapper getLogicColumn(Class<?> entityClass) {
        List listFields = (List)fieldsMap.get(entityClass.getName());
        FieldColumnMapper logicColumnMapper = null;
        int i = 0;
        while (i < listFields.size()) {
            if (((FieldColumnMapper)listFields.get(i)).isLogicDelete()) {
                logicColumnMapper = (FieldColumnMapper)listFields.get(i);
                break;
            }
            ++i;
        }
        return logicColumnMapper;
    }

    public static FieldColumnMapper getPartitionKey(Class<?> entityClass) {
        List listFields = (List)fieldsMap.get(entityClass.getName());
        FieldColumnMapper partitionKeyColumnMapper = null;
        for (FieldColumnMapper column : listFields) {
            if (column.getPartitionKey() == null) continue;
            partitionKeyColumnMapper = column;
            break;
        }
        return partitionKeyColumnMapper;
    }

    public static String selectColumnMapper(Class<?> entityClass) {
        StringBuffer selectColumn = new StringBuffer(" s_t.* ");
        int columnCount = 0;
        for (FieldColumnMapper fieldColumnMapper : (List)fieldsMap.get(entityClass.getName())) {
            ++columnCount;
            if (!fieldColumnMapper.getColumnName().equalsIgnoreCase(fieldColumnMapper.getFieldName())) {
                selectColumn.append(",").append(fieldColumnMapper.getColumnName()).append(" ").append(fieldColumnMapper.getFieldName());
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("Column {} , ColumnName : {} , FieldName : {}", new Object[]{String.format("%-3s", columnCount), String.format("%-30s", fieldColumnMapper.getColumnName()), fieldColumnMapper.getFieldName()});
        }
        return selectColumn.toString();
    }

    public static void buildColumnList(Class<?> entityClass) {
        String entityClassName = entityClass.getName();
        if (fieldsMap.containsKey(entityClassName)) {
            return;
        }
        logger.trace("entityClass {}", entityClass);
        Field[] fields = entityClass.getDeclaredFields();
        ArrayList<FieldColumnMapper> fieldColumnMapperList = new ArrayList<FieldColumnMapper>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.isAnnotationPresent(Transient.class) && field.isAnnotationPresent(Column.class)) {
                String columnName = "";
                Column columnAnnotation = field.getAnnotation(Column.class);
                columnName = columnAnnotation.name() != null && !columnAnnotation.name().equals("") ? columnAnnotation.name() : field.getName();
                columnName = MapperMetadata.tableColumnCaseConverter(columnName);
                columnName = MapperMetadata.tableColumnEscape(columnName);
                FieldColumnMapper fieldColumnMapper = new FieldColumnMapper(field, field.getName(), field.getType().getSimpleName(), columnName);
                fieldColumnMapper.setColumnAnnotation(columnAnnotation);
                if (field.isAnnotationPresent(Id.class)) {
                    fieldColumnMapper.setIdColumn(true);
                }
                if (field.isAnnotationPresent(GeneratedValue.class)) {
                    GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                    fieldColumnMapper.setGeneratedValue(generatedValue);
                    fieldColumnMapper.setGenerated(true);
                }
                if (field.isAnnotationPresent(Temporal.class)) {
                    Temporal temporalAnnotation = field.getAnnotation(Temporal.class);
                    fieldColumnMapper.setTemporalAnnotation(temporalAnnotation);
                }
                if (field.isAnnotationPresent(ColumnDefault.class)) {
                    ColumnDefault columnDefault = field.getAnnotation(ColumnDefault.class);
                    fieldColumnMapper.setColumnDefault(columnDefault);
                }
                if (field.isAnnotationPresent(PartitionKey.class)) {
                    PartitionKey partitionKey = field.getAnnotation(PartitionKey.class);
                    fieldColumnMapper.setPartitionKey(partitionKey);
                }
                if (field.isAnnotationPresent(SoftDelete.class)) {
                    SoftDelete columnLogic = field.getAnnotation(SoftDelete.class);
                    fieldColumnMapper.setSoftDelete(columnLogic);
                    fieldColumnMapper.setLogicDelete(true);
                }
                if (field.isAnnotationPresent(Encrypted.class)) {
                    Encrypted columnEncrypted = field.getAnnotation(Encrypted.class);
                    fieldColumnMapper.setEncrypted(true);
                    fieldColumnMapper.setEncryptedAnnotation(columnEncrypted);
                }
                logger.trace("FieldColumnMapper : {}", (Object)fieldColumnMapper);
                fieldColumnMapperList.add(fieldColumnMapper);
            }
            ++n2;
        }
        fieldsMap.put(entityClassName, fieldColumnMapperList);
        logger.trace("fieldsMap : {}", fieldsMap);
    }

    public static List<FieldColumnMapper> getFieldsMap(Class<?> entityClass) {
        return (List)fieldsMap.get(entityClass.getName());
    }
}

