/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.id;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dromara.mybatis.jpa.id.IdentifierGenerator;
import org.dromara.mybatis.jpa.id.impl.SnowFlakeIdGenerator;
import org.dromara.mybatis.jpa.id.impl.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierGeneratorFactory {
    private static final Logger logger = LoggerFactory.getLogger(IdentifierGeneratorFactory.class);
    static ConcurrentMap<String, IdentifierGenerator> identifierGeneratorMap = new ConcurrentHashMap<String, IdentifierGenerator>();

    public IdentifierGeneratorFactory() {
        this.register("uuid", new UUIDGenerator());
        this.register("snowflakeid", new SnowFlakeIdGenerator());
        this.register("default", new SnowFlakeIdGenerator(null));
    }

    public IdentifierGeneratorFactory(long datacenterId, long machineId) {
        this.register("uuid", new UUIDGenerator());
        this.register("snowflakeid", new SnowFlakeIdGenerator(datacenterId, machineId));
    }

    public static ConcurrentMap<String, IdentifierGenerator> getIdentifierGeneratorMap() {
        return identifierGeneratorMap;
    }

    public static void setIdentifierGeneratorMap(ConcurrentMap<String, IdentifierGenerator> identifierGeneratorMap) {
        IdentifierGeneratorFactory.identifierGeneratorMap = identifierGeneratorMap;
    }

    public void register(String strategy, IdentifierGenerator generator) {
        if (identifierGeneratorMap.containsKey(strategy = strategy.toLowerCase())) {
            return;
        }
        identifierGeneratorMap.put(strategy, generator);
        logger.debug("Registering IdentifierGenerator strategy [{}] -> [{}]", (Object)strategy, (Object)generator.getClass().getName());
    }

    public static boolean exists(String strategy) {
        return identifierGeneratorMap.containsKey(strategy.toLowerCase());
    }

    public static String generate(String strategy) {
        strategy = strategy.toLowerCase();
        return ((IdentifierGenerator)identifierGeneratorMap.get(strategy)).generate(strategy);
    }
}

