/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.cas.endpoint.ticket.service;

import java.io.Serializable;
import org.maxkey.authz.cas.endpoint.ticket.Ticket;
import org.maxkey.authz.cas.endpoint.ticket.service.RandomServiceTicketServices;
import org.maxkey.persistence.redis.RedisConnection;
import org.maxkey.persistence.redis.RedisConnectionFactory;

public class RedisTicketServices
extends RandomServiceTicketServices {
    protected int serviceTicketValiditySeconds = 600;
    RedisConnectionFactory connectionFactory;
    public static String PREFIX = "REDIS_CAS_SERVICE_TICKET_";

    public RedisTicketServices(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public RedisTicketServices() {
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected void store(String ticketId, Ticket ticket) {
        RedisConnection conn = this.connectionFactory.getConnection();
        conn.setexObject(PREFIX + ticketId, this.serviceTicketValiditySeconds, (Serializable)ticket);
        conn.close();
    }

    @Override
    public Ticket remove(String ticketId) {
        RedisConnection conn = this.connectionFactory.getConnection();
        Ticket ticket = (Ticket)conn.getObject(PREFIX + ticketId);
        conn.delete(PREFIX + ticketId);
        conn.close();
        return ticket;
    }
}

