/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.cas.endpoint.ticket.generator;

import java.security.SecureRandom;
import org.maxkey.authz.cas.endpoint.ticket.generator.RandomStringGenerator;

public class DefaultRandomStringGenerator
implements RandomStringGenerator {
    public static final int DEFAULT_MAX_RANDOM_LENGTH = 35;
    private static final char[] PRINTABLE_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ012345679".toCharArray();
    private SecureRandom randomizer = new SecureRandom();
    private int maximumRandomLength;

    public DefaultRandomStringGenerator() {
        this.maximumRandomLength = 35;
    }

    public DefaultRandomStringGenerator(int maxRandomLength) {
        this.maximumRandomLength = maxRandomLength;
    }

    @Override
    public int getMinLength() {
        return this.maximumRandomLength;
    }

    @Override
    public int getMaxLength() {
        return this.maximumRandomLength;
    }

    @Override
    public String getNewString() {
        byte[] random = this.getNewStringAsBytes();
        return this.convertBytesToString(random);
    }

    @Override
    public byte[] getNewStringAsBytes() {
        byte[] random = new byte[this.maximumRandomLength];
        this.randomizer.nextBytes(random);
        return random;
    }

    private String convertBytesToString(byte[] random) {
        char[] output = new char[random.length];
        for (int i = 0; i < random.length; ++i) {
            int index = Math.abs(random[i] % PRINTABLE_CHARACTERS.length);
            output[i] = PRINTABLE_CHARACTERS[index];
        }
        return new String(output);
    }
}

