/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.cas.endpoint.ticket;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.persistence.Column;
import javax.persistence.Id;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.maxkey.authz.cas.endpoint.ticket.Ticket;
import org.maxkey.domain.apps.AppsCasDetails;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public abstract class AbstractTicket
implements Ticket {
    private static final long serialVersionUID = -8506442397878267555L;
    @Id
    @Column(name="ID", nullable=false)
    protected String id;
    @Column(name="LAST_TIME_USED")
    protected ZonedDateTime lastTimeUsed;
    @Column(name="PREVIOUS_LAST_TIME_USED")
    protected ZonedDateTime previousLastTimeUsed;
    @Column(name="CREATION_TIME")
    protected ZonedDateTime creationTime;
    @Column(name="NUMBER_OF_TIMES_USED")
    protected int countOfUses;
    protected Authentication authentication;
    protected AppsCasDetails casDetails;

    protected AbstractTicket() {
    }

    public AbstractTicket(String id) {
        Assert.notNull((Object)id, (String)"id cannot be null");
        this.id = id;
        this.creationTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.lastTimeUsed = ZonedDateTime.now(ZoneOffset.UTC);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void update() {
        this.previousLastTimeUsed = this.lastTimeUsed;
        this.lastTimeUsed = ZonedDateTime.now(ZoneOffset.UTC);
        ++this.countOfUses;
    }

    @Override
    public int getCountOfUses() {
        return this.countOfUses;
    }

    @Override
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public ZonedDateTime getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    @Override
    public ZonedDateTime getPreviousTimeUsed() {
        return this.previousLastTimeUsed;
    }

    @Override
    public boolean isExpired() {
        return this.isExpiredInternal();
    }

    protected boolean isExpiredInternal() {
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 133).append((Object)this.getId()).toHashCode();
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public AppsCasDetails getCasDetails() {
        return this.casDetails;
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public int compareTo(Ticket o) {
        return this.getId().compareTo(o.getId());
    }
}

