/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.cas.endpoint;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.mybatis.jpa.persistence.JpaBaseDomain;
import org.maxkey.authz.cas.endpoint.ticket.ServiceTicketImpl;
import org.maxkey.authz.cas.endpoint.ticket.service.TicketServices;
import org.maxkey.authz.endpoint.AuthorizeBaseEndpoint;
import org.maxkey.config.ApplicationConfig;
import org.maxkey.dao.service.AppsCasDetailsService;
import org.maxkey.domain.apps.AppsCasDetails;
import org.maxkey.web.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CasAuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(CasAuthorizeEndpoint.class);
    @Autowired
    AppsCasDetailsService casDetailsService;
    @Autowired
    ApplicationConfig applicationConfig;
    @Autowired
    @Qualifier(value="casTicketServices")
    TicketServices ticketServices;

    @RequestMapping(value={"/authz/cas/login"})
    public ModelAndView casLogin(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="service", required=false) String casService) {
        AppsCasDetails casDetails = new AppsCasDetails();
        casDetails.setService(casService);
        List casDetailsList = this.casDetailsService.query((JpaBaseDomain)casDetails);
        casDetails = casDetailsList != null && casDetailsList.size() == 1 ? (AppsCasDetails)casDetailsList.get(0) : null;
        return this.buildCasModelAndView(casDetails);
    }

    @RequestMapping(value={"/authz/cas/{id}"})
    public ModelAndView authorize(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") String id) {
        AppsCasDetails casDetails = this.casDetailsService.getAppDetails(id);
        return this.buildCasModelAndView(casDetails);
    }

    private ModelAndView buildCasModelAndView(AppsCasDetails casDetails) {
        _logger.debug("" + casDetails);
        WebContext.setAttribute((String)"CAS_AUTHORIZE_ENDPOINT_CAS_DETAILS", (Object)casDetails);
        WebContext.setAttribute((String)"single_sign_on_app_id", (Object)casDetails.getId());
        return WebContext.redirect((String)"/authz/cas/granting");
    }

    @RequestMapping(value={"/authz/cas/granting"})
    public ModelAndView grantingTicket(HttpServletRequest request, HttpServletResponse response) {
        AppsCasDetails casDetails = (AppsCasDetails)WebContext.getAttribute((String)"CAS_AUTHORIZE_ENDPOINT_CAS_DETAILS");
        ServiceTicketImpl serviceTicket = new ServiceTicketImpl(WebContext.getAuthentication(), casDetails);
        String ticket = this.ticketServices.createTicket(serviceTicket);
        return WebContext.redirect((String)(casDetails.getService() + "?" + "ticket" + "=" + ticket));
    }
}

