/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.cas.endpoint;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.maxkey.authn.BasicAuthentication;
import org.maxkey.authz.cas.endpoint.response.ProxyServiceResponseBuilder;
import org.maxkey.authz.cas.endpoint.response.ServiceResponseBuilder;
import org.maxkey.authz.cas.endpoint.ticket.CasConstants;
import org.maxkey.authz.cas.endpoint.ticket.Ticket;
import org.maxkey.authz.cas.endpoint.ticket.service.TicketServices;
import org.maxkey.authz.endpoint.AuthorizeBaseEndpoint;
import org.maxkey.authz.endpoint.adapter.AbstractAuthorizeAdapter;
import org.maxkey.config.ApplicationConfig;
import org.maxkey.constants.BOOLEAN;
import org.maxkey.dao.service.AppsCasDetailsService;
import org.maxkey.dao.service.UserInfoService;
import org.maxkey.domain.UserInfo;
import org.maxkey.util.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class Cas20AuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(Cas20AuthorizeEndpoint.class);
    @Autowired
    AppsCasDetailsService casDetailsService;
    @Autowired
    ApplicationConfig applicationConfig;
    @Autowired
    @Qualifier(value="userInfoService")
    private UserInfoService userInfoService;
    @Autowired
    @Qualifier(value="casTicketServices")
    TicketServices ticketServices;

    @RequestMapping(value={"/authz/cas/serviceValidate"})
    @ResponseBody
    public String serviceValidate(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ticket") String ticket, @RequestParam(value="service") String service, @RequestParam(value="pgtUrl", required=false) String pgtUrl, @RequestParam(value="renew", required=false) String renew, @RequestParam(value="format", required=false, defaultValue="xml") String format) {
        Ticket storedTicket = null;
        try {
            storedTicket = this.ticketServices.consumeTicket(ticket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ServiceResponseBuilder serviceResponseBuilder = new ServiceResponseBuilder();
        if (storedTicket != null) {
            String principal = ((BasicAuthentication)storedTicket.getAuthentication().getPrincipal()).getJ_username();
            _logger.debug("principal " + principal);
            serviceResponseBuilder.success().setUser(principal);
            if (BOOLEAN.isTrue((int)storedTicket.getCasDetails().getIsAdapter())) {
                AbstractAuthorizeAdapter adapter = (AbstractAuthorizeAdapter)Instance.newInstance((String)storedTicket.getCasDetails().getAdapter());
                UserInfo userInfo = this.userInfoService.loadByUsername(principal);
                adapter.generateInfo(userInfo, (Object)serviceResponseBuilder);
            }
        } else {
            serviceResponseBuilder.failure().setCode(CasConstants.ERROR_CODE.INVALID_TICKET).setDescription("Ticket " + ticket + " not recognized");
        }
        return serviceResponseBuilder.serviceResponseBuilder();
    }

    @RequestMapping(value={"/authz/cas/proxyValidate"})
    @ResponseBody
    public String proxy(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ticket") String ticket, @RequestParam(value="service") String service, @RequestParam(value="pgtUrl", required=false) String pgtUrl, @RequestParam(value="renew", required=false) String renew, @RequestParam(value="format", required=false, defaultValue="xml") String format) {
        Ticket storedTicket = null;
        try {
            storedTicket = this.ticketServices.consumeTicket(ticket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ServiceResponseBuilder serviceResponseBuilder = new ServiceResponseBuilder();
        if (storedTicket != null) {
            serviceResponseBuilder.success().setUser(storedTicket.getAuthentication().getPrincipal().toString());
        } else {
            serviceResponseBuilder.failure().setCode(CasConstants.ERROR_CODE.INVALID_TICKET).setDescription("Ticket " + ticket + " not recognized");
        }
        return serviceResponseBuilder.serviceResponseBuilder();
    }

    @RequestMapping(value={"/authz/cas/proxy"})
    @ResponseBody
    public String proxy(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pgt") String pgt, @RequestParam(value="targetService") String targetService, @RequestParam(value="format", required=false, defaultValue="xml") String format) {
        ProxyServiceResponseBuilder proxyServiceResponseBuilder = new ProxyServiceResponseBuilder();
        return proxyServiceResponseBuilder.success().setTicket("").setFormat(format).serviceResponseBuilder();
    }
}

