/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.cas.endpoint;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.maxkey.authn.BasicAuthentication;
import org.maxkey.authz.cas.endpoint.response.Service10ResponseBuilder;
import org.maxkey.authz.cas.endpoint.ticket.Ticket;
import org.maxkey.authz.cas.endpoint.ticket.service.TicketServices;
import org.maxkey.authz.endpoint.AuthorizeBaseEndpoint;
import org.maxkey.config.ApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class Cas10AuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(Cas10AuthorizeEndpoint.class);
    @Autowired
    ApplicationConfig applicationConfig;
    @Autowired
    @Qualifier(value="casTicketServices")
    TicketServices ticketServices;

    @RequestMapping(value={"/authz/cas/validate"})
    @ResponseBody
    public String validate(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ticket") String ticket, @RequestParam(value="service") String service, @RequestParam(value="renew", required=false) String renew) {
        Ticket storedTicket = null;
        try {
            storedTicket = this.ticketServices.consumeTicket(ticket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (storedTicket != null) {
            String principal = ((BasicAuthentication)storedTicket.getAuthentication().getPrincipal()).getJ_username();
            _logger.debug("principal " + principal);
            return new Service10ResponseBuilder().success().setUser(principal).serviceResponseBuilder();
        }
        return new Service10ResponseBuilder().failure().serviceResponseBuilder();
    }
}

