/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.List;
import java.util.Map;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.AnnotationAttributesReadingVisitor;
import org.springframework.core.type.classreading.AnnotationReadingVisitorUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class MethodMetadataReadingVisitor
extends MethodVisitor
implements MethodMetadata {
    protected final String name;
    protected final int access;
    protected final String declaringClassName;
    protected final ClassLoader classLoader;
    protected final MultiValueMap<String, MethodMetadata> methodMetadataMap;
    protected final MultiValueMap<String, AnnotationAttributes> attributeMap = new LinkedMultiValueMap<String, AnnotationAttributes>(2);

    public MethodMetadataReadingVisitor(String name, int access, String declaringClassName, ClassLoader classLoader, MultiValueMap<String, MethodMetadata> methodMetadataMap) {
        super(262144);
        this.name = name;
        this.access = access;
        this.declaringClassName = declaringClassName;
        this.classLoader = classLoader;
        this.methodMetadataMap = methodMetadataMap;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType(desc).getClassName();
        this.methodMetadataMap.add(className, this);
        return new AnnotationAttributesReadingVisitor(className, this.attributeMap, null, this.classLoader);
    }

    @Override
    public String getMethodName() {
        return this.name;
    }

    @Override
    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && (this.access & 2) == 0;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return this.attributeMap.containsKey(annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        List attributes = (List)this.attributeMap.get(annotationType);
        return attributes == null ? null : AnnotationReadingVisitorUtils.convertClassValues(this.classLoader, (AnnotationAttributes)attributes.get(0), classValuesAsString);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType) {
        return this.getAllAnnotationAttributes(annotationType, false);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        if (!this.attributeMap.containsKey(annotationType)) {
            return null;
        }
        LinkedMultiValueMap<String, Object> allAttributes = new LinkedMultiValueMap<String, Object>();
        for (AnnotationAttributes annotationAttributes : (List)this.attributeMap.get(annotationType)) {
            for (Map.Entry entry : AnnotationReadingVisitorUtils.convertClassValues(this.classLoader, annotationAttributes, classValuesAsString).entrySet()) {
                allAttributes.add((String)entry.getKey(), entry.getValue());
            }
        }
        return allAttributes;
    }

    @Override
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }
}

