/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.xml.schema.loader;

import java.io.FileReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import org.apache.tsik.resource.ResourceFactory;
import org.apache.tsik.xml.schema.AttributeDeclaration;
import org.apache.tsik.xml.schema.AttributeGroup;
import org.apache.tsik.xml.schema.ComplexType;
import org.apache.tsik.xml.schema.ElementDeclaration;
import org.apache.tsik.xml.schema.Facet;
import org.apache.tsik.xml.schema.ModelGroup;
import org.apache.tsik.xml.schema.Particle;
import org.apache.tsik.xml.schema.Schema;
import org.apache.tsik.xml.schema.SchemaComponent;
import org.apache.tsik.xml.schema.SchemaConstants;
import org.apache.tsik.xml.schema.SimpleType;
import org.apache.tsik.xml.schema.Term;
import org.apache.tsik.xml.schema.Type;
import org.apache.tsik.xml.schema.Wildcard;
import org.apache.tsik.xml.schema.loader.SchemaDocumentLoader;
import org.apache.tsik.xml.schema.loader.SchemaDocumentLoaderFactory;
import org.apache.tsik.xml.schema.loader.SchemaLoader;
import org.apache.tsik.xml.schema.loader.SchemaLoaderFactory;
import org.w3c.dom.Document;

public class Dump
implements SchemaConstants {
    static String[] SS = new String[4];
    static String[] DM;
    static String[] CM;
    static String[] SV;
    static String[] SC;
    static String[] TT;
    static String[] CO;
    static String[] PC;
    static String[] NC;
    static String[] VC;
    static String[] FACET;
    static PrintStream out;
    static boolean dumpAll;
    static Schema currentSchema;

    public static void main(String[] args) throws Exception {
        int offset = 0;
        int length = args.length;
        if (args[0].equals("-a")) {
            dumpAll = true;
            ++offset;
            --length;
        }
        Dump.dump(Dump.load(args, offset, length));
    }

    public static Schema load(String[] args, int offset, int length) throws Exception {
        Document[] docs = new Document[length];
        for (int i = 0; i < length; ++i) {
            FileReader reader = new FileReader(args[i + offset]);
            docs[i] = ResourceFactory.getXMLResource().parseXML(reader);
            reader.close();
        }
        SchemaLoader loader = SchemaLoaderFactory.newLoader();
        SchemaDocumentLoader docLoader = SchemaDocumentLoaderFactory.newDocumentArrayLoader(docs);
        Schema schema = loader.loadSchema(docLoader);
        for (int i = 0; i < docs.length; ++i) {
            String ns = docs[i].getDocumentElement().getAttribute("targetNamespace");
            if (ns.length() <= 0) continue;
            schema.getType(ns, "x");
        }
        return schema;
    }

    public static void dump(Schema schema) throws Exception {
        String i = "";
        currentSchema = schema;
        out.println(i + "(all-types");
        i = Dump.indent(i);
        Iterator types = schema.getAllTypes();
        while (types.hasNext()) {
            Type type = (Type)types.next();
            if (!dumpAll && "http://www.w3.org/2001/XMLSchema".equals(type.getNamespaceURI())) continue;
            Dump.dumpType(i, type);
        }
        i = Dump.outdent(i);
        out.println(i + ")");
        out.println(i + "(all-elements");
        i = Dump.indent(i);
        Iterator elements = schema.getAllElements();
        while (elements.hasNext()) {
            ElementDeclaration elem = (ElementDeclaration)elements.next();
            Dump.dumpElement(i, elem);
        }
        i = Dump.outdent(i);
        out.println(i + ")");
        out.println(i + "(all-attributes");
        i = Dump.indent(i);
        Iterator attrs = schema.getAllAttributes();
        while (attrs.hasNext()) {
            AttributeDeclaration attr = (AttributeDeclaration)attrs.next();
            Dump.dumpAttribute(i, attr, false);
        }
        i = Dump.outdent(i);
        out.println(i + ")");
    }

    static void dumpTypeRef(String i, Type type) {
        if (type.getLocalName() != null && type.getLocalName().length() > 0 && currentSchema.getType(type.getNamespaceURI(), type.getLocalName()) != null) {
            Dump.dumpBuiltinIdentifier(i, type, "type-ref");
        } else {
            Dump.dumpType(i, type);
        }
    }

    static void dumpDerivationMethods(String i, String label, boolean isRestriction, boolean isExtension, boolean isSubstitution) {
        String s = "";
        if (isRestriction) {
            s = s + ' ' + DM[2];
        }
        if (isExtension) {
            s = s + ' ' + DM[1];
        }
        if (isSubstitution) {
            s = s + ' ' + DM[4];
        }
        if (s.length() == 0) {
            s = " none";
        }
        out.println(i + '(' + label + s + ')');
    }

    static void dumpType(String i, Type type) {
        if (type.isComplexType()) {
            out.println(i + "(complex-type");
        } else {
            out.println(i + "(simple-type");
        }
        i = Dump.indent(i);
        Dump.dumpComponent(i, type);
        Dump.dumpBuiltinIdentifier(i, type.getBaseType(), "baseType");
        if (type.isComplexType()) {
            Particle part;
            ComplexType ctype = (ComplexType)type;
            out.println(i + "(derivationMethod " + DM[ctype.getDerivationMethod()] + ")");
            Dump.dumpDerivationMethods(i, "isFinal", ctype.isFinal((short)2), ctype.isFinal((short)1), ctype.isFinal((short)4));
            Dump.dumpDerivationMethods(i, "isProhibitedSubstitution", ctype.isProhibitedSubstitution((short)2), ctype.isProhibitedSubstitution((short)1), ctype.isProhibitedSubstitution((short)4));
            out.println(i + "(abstract " + ctype.isAbstract() + ")");
            out.println(i + "(contentMode " + CM[ctype.getContentMode()] + ")");
            if (ctype.getContentMode() == 2) {
                Dump.dumpTypeRef(i, ctype.getSimpleContentType());
            }
            if ((part = ctype.getContentParticle()) != null) {
                Dump.dumpParticle(i, part);
            }
            Dump.dumpAttributeGroup(i, ctype.getAttributes());
        } else {
            SimpleType stype = (SimpleType)type;
            out.println(i + "(variety " + SV[stype.getVariety()] + ")");
            switch (stype.getVariety()) {
                case 2: {
                    out.println(i + "(primitiveType " + stype.getPrimitiveTypeDefinition().getLocalName() + ")");
                    break;
                }
                case 4: {
                    Dump.dumpBuiltinIdentifier(i, stype.getItemTypeDefinition(), "itemType");
                    break;
                }
                case 3: {
                    SimpleType[] memberTypes = stype.getMemberTypeDefinitions();
                    for (int j = 0; j < memberTypes.length; ++j) {
                        Dump.dumpBuiltinIdentifier(i, memberTypes[j], "memberType");
                    }
                    break;
                }
            }
            out.println(i + "(isOrdered " + stype.isOrdered() + ")");
            out.println(i + "(isBounded " + stype.isBounded() + ")");
            out.println(i + "(isNumeric " + stype.isNumeric() + ")");
            out.println(i + "(cardinality " + SC[stype.getCardinality()] + ")");
            Iterator it = stype.getFacets();
            if (it != null) {
                out.println(i + "(facets");
                i = Dump.indent(i);
                while (it.hasNext()) {
                    Facet f = (Facet)it.next();
                    out.println(i + "(" + FACET[f.getType()] + " " + f.getValue().toString() + (f.isFixed() ? " fixed" : "") + ")");
                }
                i = Dump.outdent(i);
                out.println(i + ")");
            }
        }
        i = Dump.outdent(i);
        out.println(i + ")");
    }

    static void dumpAttributeRef(String i, AttributeDeclaration attr, boolean isRequired) {
        if (attr.getLocalName() != null && attr.getLocalName().length() > 0 && currentSchema.getType(attr.getNamespaceURI(), attr.getLocalName()) != null) {
            Dump.dumpBuiltinIdentifier(i, attr, "attr-ref");
        } else {
            Dump.dumpAttribute(i, attr, isRequired);
        }
    }

    static void dumpAttribute(String i, AttributeDeclaration attr, boolean isRequired) {
        out.println(i + "(attribute");
        i = Dump.indent(i);
        out.println(i + "(required " + isRequired + ")");
        Dump.dumpComponent(i, attr);
        out.println(i + "(valueContraintMode " + VC[attr.getValueConstraintMode()] + ")");
        out.println(i + "(valueConstraintValue " + attr.getValueConstraintValue() + ")");
        Dump.dumpTypeRef(i, attr.getTypeDefinition());
        i = Dump.outdent(i);
        out.println(i + ")");
    }

    static void dumpAttributeGroup(String i, AttributeGroup attrs) {
        if (attrs != null) {
            out.println(i + "(attributes");
            i = Dump.indent(i);
            for (int j = 0; j < attrs.getLength(); ++j) {
                Dump.dumpAttributeRef(i, attrs.getItem(j), attrs.isItemRequired(j));
            }
            Wildcard wildcard = attrs.getWildcard();
            if (wildcard != null) {
                Dump.dumpWildcard(i, wildcard);
            }
            i = Dump.outdent(i);
            out.println(i + ")");
        } else {
            out.println(i + "(attributes null)");
        }
    }

    static void dumpBuiltinIdentifier(String i, SchemaComponent comp, String label) {
        if (comp == null) {
            out.println(i + "(" + label + " null)");
        } else if ("http://www.w3.org/2001/XMLSchema".equals(comp.getNamespaceURI())) {
            out.println(i + "(" + label + " " + comp.getLocalName() + ")");
        } else {
            out.println(i + "(" + label);
            i = Dump.indent(i);
            Dump.dumpIdentifier(i, comp);
            i = Dump.outdent(i);
            out.println(i + ")");
        }
    }

    static void dumpComponent(String i, SchemaComponent comp) {
        Dump.dumpIdentifier(i, comp);
        out.println(i + "(componentType " + SS[comp.getComponentType()] + ")");
    }

    static void dumpIdentifier(String i, SchemaComponent comp) {
        out.println(i + "(name/uri " + comp.getLocalName() + ' ' + comp.getNamespaceURI() + ")");
    }

    static void dumpParticle(String i, Particle part) {
        out.println(i + "(particle");
        i = Dump.indent(i);
        out.println(i + "(minOccurs " + part.getMinOccurs() + ")");
        out.println(i + "(maxOccurs " + part.getMaxOccurs() + ")");
        Term term = part.getTerm();
        if (term != null) {
            Dump.dumpTerm(i, term);
        }
        i = Dump.outdent(i);
        out.println(i + ")");
    }

    static void dumpTerm(String i, Term term) {
        switch (term.getTermType()) {
            case 1: {
                ModelGroup group = (ModelGroup)term;
                Dump.dumpModelGroup(i, group);
                break;
            }
            case 2: {
                Wildcard wildcard = (Wildcard)term;
                Dump.dumpWildcard(i, wildcard);
                break;
            }
            case 3: {
                ElementDeclaration elem = (ElementDeclaration)term;
                Dump.dumpElement(i, elem);
                break;
            }
            default: {
                out.println(i + "(unknown-term " + term.getTermType() + ")");
            }
        }
    }

    static void dumpModelGroup(String i, ModelGroup group) {
        out.println(i + "(model-group");
        i = Dump.indent(i);
        out.println(i + "(compositor " + CO[group.getCompositor()] + ")");
        out.println(i + "(particles");
        i = Dump.indent(i);
        for (int j = 0; j < group.getLength(); ++j) {
            Dump.dumpParticle(i, group.getItem(j));
        }
        i = Dump.outdent(i);
        out.println(i + ")");
        i = Dump.outdent(i);
        out.println(i + ")");
    }

    static void dumpWildcard(String i, Wildcard wildcard) {
        if (wildcard == null) {
            out.println(i + "(wildcard null)");
            return;
        }
        out.println(i + "(wildcard");
        i = Dump.indent(i);
        out.println(i + "(processContentsMode " + PC[wildcard.getProcessContentsMode()] + ")");
        out.println(i + "(namespaceContraintMode " + NC[wildcard.getNamespaceConstraintMode()] + ")");
        out.println(i + "(notNamespaceURI " + wildcard.getNotNamespaceURI() + ")");
        Set set = wildcard.getNamespaceSet();
        if (set != null) {
            out.println(i + "(namespaceSet");
            i = Dump.indent(i);
            Iterator uris = set.iterator();
            while (uris.hasNext()) {
                out.println(i + "(uri " + uris.next() + ")");
            }
            i = Dump.outdent(i);
            i = ")";
            out.println(")");
        } else {
            out.println(i + "(namespaceSet null)");
        }
        i = Dump.outdent(i);
        out.println(i + ")");
    }

    static void dumpElement(String i, ElementDeclaration elem) {
        Set members;
        out.println(i + "(element");
        i = Dump.indent(i);
        Dump.dumpComponent(i, elem);
        Dump.dumpDerivationMethods(i, "isDisallowedSubstitution", elem.isDisallowedSubstitution((short)2), elem.isDisallowedSubstitution((short)1), elem.isDisallowedSubstitution((short)4));
        Dump.dumpDerivationMethods(i, "isSubstitutionGroupExclusion", elem.isSubstitutionGroupExclusion((short)2), elem.isSubstitutionGroupExclusion((short)1), elem.isSubstitutionGroupExclusion((short)4));
        ElementDeclaration head = elem.getSubstitutionGroupHead();
        if (head != null) {
            out.println(i + "(substitutionGroupHead");
            i = Dump.indent(i);
            Dump.dumpIdentifier(i, head);
            i = Dump.outdent(i);
            out.println(i + ")");
        }
        if ((members = elem.getSubstitutionGroupMembers()).size() > 1 || !members.contains(elem)) {
            out.println(i + "(substitutionGroupMembers [except self]");
            i = Dump.indent(i);
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ElementDeclaration next = (ElementDeclaration)iter.next();
                if (next == elem) continue;
                Dump.dumpIdentifier(i, next);
            }
            i = Dump.outdent(i);
            out.println(i + ")");
        }
        Dump.dumpTypeRef(i, elem.getTypeDefinition());
        i = Dump.outdent(i);
        out.println(i + ")");
    }

    static String indent(String i) {
        return i + "  ";
    }

    static String outdent(String i) {
        return i.substring(0, i.length() - 2);
    }

    static {
        Dump.SS[1] = "SS_TYPE";
        Dump.SS[2] = "SS_ELEMENT";
        Dump.SS[3] = "SS_ATTRIBUTE";
        DM = new String[5];
        Dump.DM[1] = "DM_EXTENSION";
        Dump.DM[2] = "DM_RESTRICTION";
        Dump.DM[4] = "DM_SUBSTITUTION";
        CM = new String[5];
        Dump.CM[1] = "CM_EMPTY";
        Dump.CM[2] = "CM_SIMPLE";
        Dump.CM[3] = "CM_ELEMENT_ONLY";
        Dump.CM[4] = "CM_MIXED";
        SV = new String[5];
        Dump.SV[1] = "SV_NONE";
        Dump.SV[2] = "SV_ATOMIC";
        Dump.SV[3] = "SV_UNION";
        Dump.SV[4] = "SV_LIST";
        SC = new String[4];
        Dump.SC[1] = "SC_FINITE";
        Dump.SC[2] = "SC_COUNTABLY_INFINITE";
        Dump.SC[3] = "SC_UNCOUNTABLY_INFINITE";
        TT = new String[4];
        Dump.TT[1] = "TT_MODEL_GROUP";
        Dump.TT[2] = "TT_WILDCARD";
        Dump.TT[3] = "TT_ELEMENT";
        CO = new String[4];
        Dump.CO[1] = "CO_SEQUENCE";
        Dump.CO[2] = "CO_CHOICE";
        Dump.CO[3] = "CO_ALL";
        PC = new String[4];
        Dump.PC[1] = "PC_STRICT";
        Dump.PC[2] = "PC_SKIP";
        Dump.PC[3] = "PC_LAX";
        NC = new String[4];
        Dump.NC[1] = "NC_ANY";
        Dump.NC[2] = "NC_NOT";
        Dump.NC[3] = "NC_SET";
        VC = new String[4];
        Dump.VC[1] = "VC_NONE";
        Dump.VC[2] = "VC_DEFAULT";
        Dump.VC[3] = "VC_FIXED";
        FACET = new String[16];
        Dump.FACET[1] = "length";
        Dump.FACET[2] = "minLength";
        Dump.FACET[3] = "maxLength";
        Dump.FACET[4] = "pattern";
        Dump.FACET[5] = "enumeration";
        Dump.FACET[6] = "whiteSpace";
        Dump.FACET[7] = "maxInclusive";
        Dump.FACET[8] = "maxExclusive";
        Dump.FACET[9] = "minInclusive";
        Dump.FACET[10] = "minExclusive";
        Dump.FACET[11] = "precision";
        Dump.FACET[12] = "scale";
        Dump.FACET[13] = "encoding";
        Dump.FACET[14] = "duration";
        Dump.FACET[15] = "period";
        out = System.out;
    }
}

