/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.wss.actions;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import org.apache.tsik.util.Namespaces;
import org.apache.tsik.wsp.Action;
import org.apache.tsik.wsp.ActionViolation;
import org.apache.tsik.xmlsig.Verifier;
import org.apache.tsik.xpath.XPath;

public class VerifyBody
extends Action {
    private X509Certificate cert;
    private XPath sigXpath;

    private boolean checkPreconditions() {
        this.cert = this.getX509Certificate("cert");
        this.sigXpath = this.getXPath("sigloc");
        if (this.cert == null || this.sigXpath == null) {
            return false;
        }
        return this.moveOutputToXPath(this.sigXpath);
    }

    public void execute() {
        boolean isVerified;
        if (!this.checkPreconditions()) {
            this.violations.add(new ActionViolation("Precond check failed"));
            return;
        }
        PublicKey key = this.cert.getPublicKey();
        Verifier verifier = null;
        try {
            verifier = new Verifier(this.output.getDocument(), this.sigXpath);
            isVerified = verifier.verify(key);
        }
        catch (SignatureException e) {
            this.violations.add(new ActionViolation((Exception)e));
            return;
        }
        catch (InvalidKeyException e) {
            this.violations.add(new ActionViolation((Exception)e));
            return;
        }
        catch (NoSuchAlgorithmException e) {
            this.violations.add(new ActionViolation((Exception)e));
            return;
        }
        if (!isVerified) {
            this.violations.add(new ActionViolation("Signature does not verify"));
            return;
        }
        String s = "/s:Envelope/s:Body";
        String[] ns = new String[]{"s", Namespaces.SOAPENV.getUri()};
        XPath body = new XPath(s, ns);
        if (!verifier.isReferenced(body)) {
            s = "Soap body is not referenced in signature";
            this.violations.add(new ActionViolation(s));
            return;
        }
    }

    public boolean needsOutputDocument() {
        return true;
    }
}

