/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.datatypes;

import java.util.Date;

public final class TimeInterval {
    private long notBefore;
    private long notAfter;

    public TimeInterval(long notBefore, long notAfter) {
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.validate();
    }

    public TimeInterval(Date notBefore, Date notAfter) {
        this.notBefore = notBefore == null ? Long.MIN_VALUE : notBefore.getTime();
        this.notAfter = notAfter == null ? Long.MAX_VALUE : notAfter.getTime();
        this.validate();
    }

    private void validate() {
        if (this.notBefore >= this.notAfter) {
            throw new IllegalArgumentException("TimeInterval: notBefore >= notAfter");
        }
    }

    public int hashCode() {
        return (int)(this.notAfter >>> 32 & 0xFFFFFFFFL) ^ (int)(this.notAfter & 0xFFFFFFFFL) ^ (int)(this.notBefore >>> 32 & 0xFFFFFFFFL) ^ (int)(this.notBefore & 0xFFFFFFFFL);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof TimeInterval && this.equals((TimeInterval)o);
    }

    public boolean equals(TimeInterval interval) {
        return this.notBefore == interval.notBefore && this.notAfter == interval.notAfter;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public boolean contains(long instant) {
        return instant >= this.notBefore && instant < this.notAfter;
    }

    public boolean contains(TimeInterval interval) {
        return this.notBefore <= interval.notBefore && this.notAfter >= interval.notAfter;
    }
}

