/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.datatypes;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTime {
    private static SimpleDateFormat dateFormat;
    private static SimpleDateFormat dateTimeFormat;
    private static TimeZone utcZone;

    public static Date parseISODate(String date) throws ParseException {
        return DateTime.clearTime(dateFormat.parse(date));
    }

    public static Date parseISODateTime(String dateTime) throws ParseException {
        int millis = 0;
        int i = dateTime.indexOf(46);
        if (i >= 0 && dateTime.charAt(dateTime.length() - 1) == 'Z') {
            String s = dateTime.substring(i + 1, dateTime.length() - 1);
            millis = Integer.parseInt(s);
            dateTime = dateTime.substring(0, i) + 'Z';
        }
        Date d = dateTimeFormat.parse(dateTime);
        if (millis > 0) {
            d = new Date(d.getTime() + (long)millis);
        }
        return d;
    }

    public static String formatISODate(Date date) {
        return dateFormat.format(date);
    }

    public static String formatISODateTime(Date dateTime) {
        return dateTimeFormat.format(dateTime);
    }

    public static Date clearTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(utcZone);
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    static {
        utcZone = TimeZone.getTimeZone("UTC");
        dateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd");
        dateTimeFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
        dateFormat.setTimeZone(utcZone);
        dateTimeFormat.setTimeZone(utcZone);
    }
}

