/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsik.c14n;

import java.util.Comparator;
import org.apache.tsik.common.Logger;
import org.apache.tsik.common.LoggerFactory;
import org.apache.tsik.resource.DOMOperations;
import org.w3c.dom.Attr;

class AttributeComparator
implements Comparator {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$tsik$c14n$AttributeComparator == null ? (class$org$apache$tsik$c14n$AttributeComparator = AttributeComparator.class$("org.apache.tsik.c14n.AttributeComparator")) : class$org$apache$tsik$c14n$AttributeComparator);
    private static final DOMOperations ops = DOMOperations.getInstance();
    static /* synthetic */ Class class$org$apache$tsik$c14n$AttributeComparator;

    AttributeComparator() {
    }

    public int compare(Object obj1, Object obj2) {
        Attr a1 = (Attr)obj1;
        Attr a2 = (Attr)obj2;
        boolean isNs1 = AttributeComparator.isNamespaceAttr(a1);
        boolean isNs2 = AttributeComparator.isNamespaceAttr(a2);
        if (isNs1 && isNs2) {
            boolean b1 = AttributeComparator.getLocalName(a1).equals("xmlns");
            boolean b2 = AttributeComparator.getLocalName(a2).equals("xmlns");
            if (b1 && b2) {
                return this.doAttrCompare(a1, a2);
            }
            if (!b1 && !b2) {
                return AttributeComparator.getLocalName(a1).compareTo(AttributeComparator.getLocalName(a2));
            }
            if (b1) {
                return -1;
            }
            if (b2) {
                return 1;
            }
            log.error("we shouldn't be here!!");
            return 0;
        }
        if (!isNs1 && !isNs2) {
            return this.doAttrCompare(a1, a2);
        }
        if (!isNs1) {
            return 1;
        }
        if (!isNs2) {
            return -1;
        }
        log.error("we shouldn't be here either!!");
        return 0;
    }

    private int doAttrCompare(Attr a1, Attr a2) {
        int result;
        String ns1 = ops.getNamespaceURI(a1);
        String ns2 = ops.getNamespaceURI(a2);
        boolean hasEmptyNs1 = this.hasEmptyNamespace(a1);
        boolean hasEmptyNs2 = this.hasEmptyNamespace(a2);
        if (!hasEmptyNs1 && !hasEmptyNs2 && (result = ns1.compareTo(ns2)) != 0) {
            return result;
        }
        if (hasEmptyNs1 && !hasEmptyNs2) {
            return -1;
        }
        if (!hasEmptyNs1 && hasEmptyNs2) {
            return 1;
        }
        String name1 = AttributeComparator.getLocalName(a1);
        String name2 = AttributeComparator.getLocalName(a2);
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    static boolean isNamespaceAttr(Attr a) {
        String localName = AttributeComparator.getLocalName(a);
        if ("xmlns".equals(localName)) {
            return true;
        }
        String prefix = ops.getPrefix(a);
        if (prefix == null) {
            return false;
        }
        return prefix.startsWith("xmlns");
    }

    private static String getLocalName(Attr a) {
        return ops.getLocalName(a);
    }

    private boolean hasEmptyNamespace(Attr a) {
        return ops.getNamespaceURI(a) == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

