/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence.provider;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.mybatis.jpa.PageResultsSqlCache;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.JpaBaseService;
import org.apache.mybatis.jpa.persistence.JpaPagination;
import org.apache.mybatis.jpa.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageResultsCountProvider<T extends JpaBaseEntity> {
    private static final Logger _logger = LoggerFactory.getLogger(PageResultsCountProvider.class);

    public String executePageResultsCount(T entity) {
        T pagination = entity;
        PageResultsSqlCache pageResultsSqlCache = (PageResultsSqlCache)JpaBaseService.pageResultsBoundSqlCache.getIfPresent((Object)((JpaPagination)pagination).getPageResultSelectUUID());
        String selectSql = StringUtils.lineBreak2Blank(pageResultsSqlCache.getSql());
        BoundSql boundSql = pageResultsSqlCache.getBoundSql();
        _logger.trace("Count original SQL  :\n{}", (Object)selectSql);
        StringBuffer sql = new StringBuffer("select count(1) countrows_ ");
        StringBuffer countSql = new StringBuffer();
        if (boundSql.getParameterMappings() == null || boundSql.getParameterMappings().isEmpty()) {
            countSql.append(selectSql);
        } else {
            for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                countSql.append(selectSql.substring(0, selectSql.indexOf("?")));
                countSql.append("#{" + parameterMapping.getProperty() + "}");
                selectSql = selectSql.substring(selectSql.indexOf("?") + 1);
            }
            countSql.append(selectSql);
        }
        String countSqlLowerCase = countSql.toString().toLowerCase();
        _logger.trace("Count SQL LowerCase  :\n{}", (Object)countSqlLowerCase);
        if (countSqlLowerCase.indexOf("distinct ") > 0 || countSqlLowerCase.indexOf(" group by ") > 0 || countSqlLowerCase.indexOf(" having ") > 0 || countSqlLowerCase.indexOf(" from ") != countSqlLowerCase.lastIndexOf(" from ")) {
            _logger.trace("Count SQL Complex ");
            sql.append("from").append(" (").append(countSql).append(" ) count_table_");
        } else {
            int fromIndex = countSqlLowerCase.indexOf(" from ");
            int orderByIndex = countSqlLowerCase.indexOf(" order by ");
            _logger.trace("Count SQL from Index {} , order by {}", (Object)fromIndex, (Object)orderByIndex);
            if (orderByIndex > -1) {
                sql.append(countSql.substring(fromIndex, orderByIndex));
            } else {
                sql.append(countSql.substring(fromIndex));
            }
        }
        JpaBaseService.pageResultsBoundSqlCache.invalidate((Object)((JpaPagination)pagination).getPageResultSelectUUID());
        _logger.trace("Count SQL : \n{}", (Object)sql);
        return sql.toString();
    }
}

