/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.io;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.CryptProvider;
import edu.vt.middleware.crypt.io.AbstractEncodedCredentialReader;
import edu.vt.middleware.crypt.io.IOHelper;
import edu.vt.middleware.crypt.pbe.AbstractEncryptionScheme;
import edu.vt.middleware.crypt.pbe.OpenSSLEncryptionScheme;
import edu.vt.middleware.crypt.pbe.PBES1EncryptionScheme;
import edu.vt.middleware.crypt.pbe.PBES2EncryptionScheme;
import edu.vt.middleware.crypt.pkcs.PBEParameter;
import edu.vt.middleware.crypt.pkcs.PBES1Algorithm;
import edu.vt.middleware.crypt.pkcs.PBES2CipherGenerator;
import edu.vt.middleware.crypt.pkcs.PBKDF2Parameters;
import edu.vt.middleware.crypt.util.Convert;
import edu.vt.middleware.crypt.util.PemHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivateKeyCredentialReader
extends AbstractEncodedCredentialReader<PrivateKey> {
    public PrivateKey read(File file, char[] password) throws IOException, CryptException {
        byte[] data = IOHelper.read(new FileInputStream(file).getChannel());
        data = this.decryptKey(data, password);
        return this.decode(data);
    }

    public PrivateKey read(InputStream in, char[] password) throws CryptException, IOException {
        byte[] data = IOHelper.read(in);
        data = this.decryptKey(data, password);
        return this.decode(data);
    }

    @Override
    protected PrivateKey decode(byte[] encoded) throws CryptException {
        KeySpec spec;
        String algorithm;
        PrivateKeyInfo pi;
        ASN1Object o;
        try {
            o = ASN1Object.fromByteArray((byte[])encoded);
        }
        catch (Exception e) {
            throw new CryptException("Key is not ASN.1 encoded data.");
        }
        try {
            pi = PrivateKeyInfo.getInstance((Object)o);
        }
        catch (Exception e) {
            pi = null;
        }
        if (pi != null) {
            String algOid = pi.getAlgorithmId().getObjectId().getId();
            if (RSA_ID.equals((Object)pi.getAlgorithmId().getObjectId())) {
                algorithm = "RSA";
            } else if (DSA_ID.equals((Object)pi.getAlgorithmId().getObjectId())) {
                algorithm = "DSA";
            } else {
                throw new CryptException("Unsupported PKCS#8 algorithm ID " + algOid);
            }
            try {
                spec = new PKCS8EncodedKeySpec(encoded);
            }
            catch (Exception e) {
                throw new CryptException("Invalid PKCS#8 private key format.", e);
            }
        } else {
            DERSequence sequence = (DERSequence)o;
            if (sequence.size() == 9) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Reading OpenSSL format RSA private key.");
                }
                algorithm = "RSA";
                try {
                    spec = new RSAPrivateCrtKeySpec(DERInteger.getInstance((Object)sequence.getObjectAt(1)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(2)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(3)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(4)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(5)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(6)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(7)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(8)).getValue());
                }
                catch (Exception e) {
                    throw new CryptException("Invalid RSA key.", e);
                }
            } else if (sequence.size() == 6) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Reading OpenSSL format DSA private key.");
                }
                algorithm = "DSA";
                try {
                    spec = new DSAPrivateKeySpec(DERInteger.getInstance((Object)sequence.getObjectAt(5)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(1)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(2)).getValue(), DERInteger.getInstance((Object)sequence.getObjectAt(3)).getValue());
                }
                catch (Exception e) {
                    throw new CryptException("Invalid DSA key.", e);
                }
            } else {
                throw new CryptException("Invalid OpenSSL traditional private key format.");
            }
        }
        try {
            return CryptProvider.getKeyFactory(algorithm).generatePrivate(spec);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptException("Invalid key specification", e);
        }
    }

    private byte[] decryptKey(byte[] encrypted, char[] password) throws IOException, CryptException {
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("Password is required for decrypting an encrypted private key.");
        }
        byte[] bytes = encrypted;
        if (PemHelper.isPem(encrypted)) {
            String pem;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Reading PEM encoded private key.");
            }
            bytes = (pem = new String(encrypted, "ASCII")).contains("Proc-Type:") ? this.decryptOpenSSLKey(pem, password) : this.decryptPKCS8Key(PemHelper.decode(bytes), password);
        } else {
            bytes = this.decryptPKCS8Key(bytes, password);
        }
        return bytes;
    }

    private byte[] decryptOpenSSLKey(String encrypted, char[] password) throws CryptException {
        try {
            int start = encrypted.indexOf("DEK-Info:");
            int eol = encrypted.indexOf(10, start);
            String[] dekInfo = encrypted.substring(start + 10, eol).split(",");
            String alg = dekInfo[0];
            byte[] iv = Convert.fromHex(dekInfo[1]);
            byte[] bytes = PemHelper.decode(encrypted);
            return new OpenSSLEncryptionScheme(alg, iv).decrypt(password, bytes);
        }
        catch (Exception e) {
            throw new CryptException("Failed decrypting OpenSSL key.", e);
        }
    }

    private byte[] decryptPKCS8Key(byte[] encrypted, char[] password) throws CryptException {
        try {
            AbstractEncryptionScheme scheme;
            EncryptedPrivateKeyInfo ki = EncryptedPrivateKeyInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])encrypted));
            AlgorithmIdentifier alg = ki.getEncryptionAlgorithm();
            if (PKCSObjectIdentifiers.id_PBES2.equals((Object)alg.getObjectId())) {
                DERSequence pbeSeq = (DERSequence)alg.getParameters();
                PBKDF2Parameters kdfParms = PBKDF2Parameters.decode((DERSequence)pbeSeq.getObjectAt(0));
                PBES2CipherGenerator cipherGen = new PBES2CipherGenerator((DERSequence)pbeSeq.getObjectAt(1));
                if (kdfParms.getLength() == 0) {
                    kdfParms.setLength(cipherGen.getKeySize() / 8);
                }
                scheme = new PBES2EncryptionScheme(cipherGen.generate(), kdfParms);
            } else {
                scheme = new PBES1EncryptionScheme(PBES1Algorithm.fromOid(alg.getObjectId().getId()), PBEParameter.decode((DERSequence)alg.getParameters()));
            }
            return scheme.decrypt(password, ki.getEncryptedData());
        }
        catch (Exception e) {
            throw new CryptException("Failed decrypting PKCS#8 private key", e);
        }
    }
}

