/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.streamingaead;

import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.StreamingAead;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

final class SeekableByteChannelDecrypter
implements SeekableByteChannel {
    @GuardedBy(value="this")
    boolean attemptedMatching = false;
    @GuardedBy(value="this")
    SeekableByteChannel matchingChannel = null;
    @GuardedBy(value="this")
    SeekableByteChannel ciphertextChannel;
    @GuardedBy(value="this")
    long cachedPosition;
    @GuardedBy(value="this")
    long startingPosition;
    PrimitiveSet<StreamingAead> primitives;
    byte[] associatedData;

    public SeekableByteChannelDecrypter(PrimitiveSet<StreamingAead> primitives, SeekableByteChannel ciphertextChannel, byte[] associatedData) throws IOException {
        this.primitives = primitives;
        this.ciphertextChannel = ciphertextChannel;
        this.cachedPosition = -1L;
        this.startingPosition = ciphertextChannel.position();
        this.associatedData = (byte[])associatedData.clone();
    }

    @Override
    @GuardedBy(value="this")
    public synchronized int read(ByteBuffer dst) throws IOException {
        List<PrimitiveSet.Entry<StreamingAead>> entries;
        if (dst.remaining() == 0) {
            return 0;
        }
        if (this.matchingChannel != null) {
            return this.matchingChannel.read(dst);
        }
        if (this.attemptedMatching) {
            throw new IOException("No matching key found for the ciphertext in the stream.");
        }
        this.attemptedMatching = true;
        try {
            entries = this.primitives.getRawPrimitives();
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Keyset failure: ", e);
        }
        for (PrimitiveSet.Entry<StreamingAead> entry : entries) {
            try {
                int retValue;
                SeekableByteChannel attemptedChannel = entry.getPrimitive().newSeekableDecryptingChannel(this.ciphertextChannel, this.associatedData);
                if (this.cachedPosition >= 0L) {
                    attemptedChannel.position(this.cachedPosition);
                }
                if ((retValue = attemptedChannel.read(dst)) > 0) {
                    this.matchingChannel = attemptedChannel;
                } else if (retValue == 0) {
                    this.ciphertextChannel.position(this.startingPosition);
                    this.attemptedMatching = false;
                }
                this.matchingChannel = attemptedChannel;
                return retValue;
            }
            catch (IOException e) {
                this.ciphertextChannel.position(this.startingPosition);
            }
            catch (GeneralSecurityException e) {
                this.ciphertextChannel.position(this.startingPosition);
            }
        }
        throw new IOException("No matching key found for the ciphertext in the stream.");
    }

    @Override
    @GuardedBy(value="this")
    public synchronized SeekableByteChannel position(long newPosition) throws IOException {
        if (this.matchingChannel != null) {
            this.matchingChannel.position(newPosition);
        } else {
            if (newPosition < 0L) {
                throw new IllegalArgumentException("Position must be non-negative");
            }
            this.cachedPosition = newPosition;
        }
        return this;
    }

    @Override
    @GuardedBy(value="this")
    public synchronized long position() throws IOException {
        if (this.matchingChannel != null) {
            return this.matchingChannel.position();
        }
        return this.cachedPosition;
    }

    @Override
    @GuardedBy(value="this")
    public synchronized long size() throws IOException {
        if (this.matchingChannel != null) {
            return this.matchingChannel.size();
        }
        throw new IOException("Cannot determine size before first read()-call.");
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    @GuardedBy(value="this")
    public synchronized void close() throws IOException {
        this.ciphertextChannel.close();
    }

    @Override
    @GuardedBy(value="this")
    public synchronized boolean isOpen() {
        return this.ciphertextChannel.isOpen();
    }
}

