/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.KeyManager;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.subtle.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public final class PublicKeyVerifyFactory {
    private static final Logger logger = Logger.getLogger(PublicKeyVerifyFactory.class.getName());

    public static PublicKeyVerify getPrimitive(KeysetHandle keysetHandle) throws GeneralSecurityException {
        return PublicKeyVerifyFactory.getPrimitive(keysetHandle, null);
    }

    public static PublicKeyVerify getPrimitive(KeysetHandle keysetHandle, KeyManager<PublicKeyVerify> keyManager) throws GeneralSecurityException {
        final PrimitiveSet<PublicKeyVerify> primitives = Registry.getPrimitives(keysetHandle, keyManager);
        PublicKeyVerifyFactory.validate(primitives);
        return new PublicKeyVerify(){

            @Override
            public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
                if (signature.length <= 5) {
                    throw new GeneralSecurityException("signature too short");
                }
                byte[] prefix = Arrays.copyOfRange(signature, 0, 5);
                byte[] sigNoPrefix = Arrays.copyOfRange(signature, 5, signature.length);
                List entries = primitives.getPrimitive(prefix);
                for (PrimitiveSet.Entry entry : entries) {
                    try {
                        if (entry.getOutputPrefixType().equals((Object)OutputPrefixType.LEGACY)) {
                            byte[] formatVersion = new byte[]{0};
                            byte[] dataWithFormatVersion = Bytes.concat(data, formatVersion);
                            ((PublicKeyVerify)entry.getPrimitive()).verify(sigNoPrefix, dataWithFormatVersion);
                        } else {
                            ((PublicKeyVerify)entry.getPrimitive()).verify(sigNoPrefix, data);
                        }
                        return;
                    }
                    catch (GeneralSecurityException e) {
                        logger.info("signature prefix matches a key, but cannot verify: " + e.toString());
                    }
                }
                entries = primitives.getRawPrimitives();
                for (PrimitiveSet.Entry entry : entries) {
                    try {
                        ((PublicKeyVerify)entry.getPrimitive()).verify(signature, data);
                        return;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                    }
                }
                throw new GeneralSecurityException("invalid signature");
            }
        };
    }

    private static void validate(PrimitiveSet<PublicKeyVerify> pset) throws GeneralSecurityException {
        for (Collection collection : pset.getAll()) {
            for (PrimitiveSet.Entry entry : collection) {
                if (entry.getPrimitive() instanceof PublicKeyVerify) continue;
                throw new GeneralSecurityException("invalid PublicKeyVerify key material");
            }
        }
    }
}

